<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['blogs/(:any)'] = 'blogs/posts/$1';


$route['silver-products/(:any)'] = 'silver-products/show/$1';
$route['products/(:any)'] = 'products/view/$1';
$route['silver-stores-in-mumbai'] = 'store-locator/silver-stores-in-mumbai';
$route['silver-stores-in-mumbai-borivali'] = 'store-locator/silver-stores-in-mumbai-borivali';
$route['silver-stores-in-mumbai-vile-parle'] = 'store-locator/silver-stores-in-mumbai-vile-parle';
$route['silver-stores-in-hydrabad'] = 'store-locator/silver-stores-in-hydrabad';
$route['silver-stores-in-bangaluru'] = 'store-locator/silver-stores-in-bangaluru';
$route['silver-stores-in-chennai'] = 'store-locator/silver-stores-in-chennai';
$route['silver-stores-in-jaipur'] = 'store-locator/silver-stores-in-jaipur';

$route['blogs'] = 'blogs/index';

$route['default_controller'] = 'templates/home';
$route['404_override'] = 'about/coming_soon';
$route['translate_uri_dashes'] = TRUE;
