<?php
class About extends MX_Controller 
{

function __construct() {
parent::__construct();
}

public function history_of_silver_emporium()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Pure Silver Products Online.";
    $data['meta_description']   = "Silver Emporium, came into existence and is the largest manufacturer of pure silver articles and products in India with presence in over 5 states since the past 27 years. Awarded as India’s best silverware manufacturer of India";
    $data['meta_keywords']      = "silver emporium, largest silver manufacturer, pure silver products online, showpieces in silver, silver jewellery, 1st silverware company, high quality products, good silver designs, authenticated silver";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "history";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function board_members()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Board Members | Silver Dinner Sets Online";
    $data['meta_description']   = "Kantilal Mehta is President of IVF (International Vaish Foundation) Mumbai, Chairman of Silver Emporium Pvt. Ltd., Past Chairman of World Silver Council and Past Director India Bullion and Jewellery Association.";
    $data['meta_keywords']      = "silver emporium, silver products, antique silver, first bike in silver, largest manufacturer of silver, Rolls-Royce, Rolls-Royce in silver, largest silver company, silverware company";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "boardmembers";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function milestones()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Milestones | Silver manufacturer in India";
    $data['meta_description']   = "silver emporium Started their 1st manufacturing plant in Jaipur and now in 2019 they are on amazon with good silver products for your requirements";
    $data['meta_keywords']      = "silver emporium, silverware, sterling silver, silver 92.5, luxurious lifestyle, 1st silverware company, first silverware company ";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "milestones";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function our_clients()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Our Clients | Pure Silver Products Online";
    $data['meta_description']   = "Silver Emporium also has some of the corporate clients like Aditya Birla, HDFC Bank and over 500 corporates, chain of jewellery store, jewellery brands of large corporates. We help them deliver the best of silver.";
    $data['meta_keywords']      = "Silver emporium clients,  silver store near me, best silver stone in Mumbai";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "ourclients";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function vision_of_silver_emporium()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Vision Mission Value | Best Silverware in Mumbai";
    $data['meta_description']   = "In silver emporium we believe in providing consistent quality products which ensures long term customer relationship";
    $data['meta_keywords']      = "silver emporium, high quality products, good silver design, 925silver silver masterpeice, pure silver";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "vmv";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function how_we_do_it()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | How We Do It | Pure 925 Silver";
    $data['meta_description']   = "Process of melting silver by mixing other ores with it to gather desirable purity is called melting process.";
    $data['meta_keywords']      = "silver emporium, silver products, making of silver, silver 92.5, antique silver, sterling silver";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "howwedoit";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

//
public function memberships()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Memberships | Sterling Silver";
    $data['meta_description']   = "Here in Silver Emporium we show you the whole manufacturing process. All behind the scenes hard work and dedication that gives best silver articles to our beloved customers.";
    $data['meta_keywords']      = "silver emporium membership, members of silver emporium, silver emporium best silver ware in mumbai";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "memberships";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

public function how_it_made()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | How We Made Our Products | Pure Silver Products";
    $data['meta_description']   = "In this video you can see how silver emporium made their products by maintaining quality and always adopt new designs and concepts ";
    $data['meta_keywords']      = "silver emporium, india's best silverware, silver jewellery, silverware, showpieces in silver, silverware manufacturer, handcrafted home decor, silver tea sets, silver plated glasses, silver products, silver for occasions, silver for festivals, 92.5 hallmarked silver, unique gifts, festive gifts, home decor, silver masterpieces, housewarming gifts, great collection";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "how_it_made";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}


//
public function careers()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Careers in Silver Emporium | Jobs Vanancy";
    $data['meta_description']   = "We offer unrivalled progression with a broad range of exciting careers. We are looking for enthusiastic, energetic, flexible team players who will enjoy the excitement and challenges of working for a very successful and rapidly expanding organization";
    $data['meta_keywords']      = "silver emporium hiring, silver emporium job, silver emporium recruitment, jobs in silver industries, jobs near me";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "careers";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}

public function request()
{
    //echo "hii";
    $newCareerDetails = $this->input->post();
    $fileName = '';
    $this->form_validation->set_rules('name','Name','required',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.'
                                            ));
    $this->form_validation->set_rules('qualification','Qualification','required',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.'
                                            ));
    $this->form_validation->set_rules('contact','Contact Number','required|numeric',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.',
                                            'numeric' => '%s should not contain text.'
                                            ));
    $this->form_validation->set_rules('email','Email Address','required|valid_email',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.',
                                            'valid_email' =>'%s is not valid.'
                                            ));
    $this->form_validation->set_rules('address','Address','required',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.'
                                            ));
    $this->form_validation->set_rules('position','Position Applying for','required',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.'
                                            ));
    $this->form_validation->set_rules('city','City','required',
                                        array(
                                            'required' => 'Please enter %s it is mandatory.'
                                            ));
    if($this->form_validation->run())
    {
        $config = array(
            'upload_path' => './assets/resumes/',
            'allowed_types' => 'docx|doc|PDF|pdf|jpeg|jpg',
            'max-size' =>5000,
            'filename' => $this->input->post('file')
        );
        $this->load->library('upload', $config);
        $uploadFile =  $this->upload->do_upload('file');
        if($uploadFile)
        {
            $data = $this->upload->data();
            $fileName = $data['file_name'];
            $this->load->model('AboutModel');
            $saveData = $this->AboutModel->save_career_details($newCareerDetails,$fileName);
            if($saveData)
            {
                $email = $this->input->post('email');
                $this->session->set_flashdata('success', "Thank you for the details we will get back to you soon !!");
                $this->send_confirmation_mail_to_user($email);
                $this->send_confirmation_mail_to_admin($newCareerDetails,$fileName);
                redirect('about/careers');
            }
            else
            {
                $this->session->set_flashdata('not_success', "Data did not store !!");
                redirect('about/careers');
            }
            //echo "uploaded";
        }
        else
        {
            $file_error = $this->upload->display_errors();
            $this->session->set_flashdata('file_error', $file_error);
            $this->Careers();
            //echo "not";

        }
    }
    else
    {
        $this->Careers();
    }
}
    
public function coming_soon()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Page Not Found";
    $data['meta_description']   = "silver emporium. page not found error page. go to the home page";
    $data['meta_keywords']      = "silver emporium, silver coins, silver gifts, silver coins, silver antiques";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "coming_soon";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);


}

public function delete()
{
    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
    
    $id = $this->uri->segment(3);
    $this->load->model('AboutModel');
    $this->AboutModel->delete($id);
    $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Query Removed successfully !!'.'</p>');
      redirect('about/carrer-manage');
}

public function carrer_manage()
{
    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }

    $data['query'] = $this->get('id');
    $data['headline'] = "Queries in Careers from Users";


    $data['view_file'] = "manage_career";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function get($order_by)
{
    $this->load->model('AboutModel');
    $query = $this->AboutModel->get($order_by);
    return $query;
}

public function send_confirmation_mail_to_user($email)
{ 

  $this->load->library('email');

    $subject = 'Thanks for you query in Silver Emporium';
    $message = '<table border="0" style="width: 700px; margin: 0 auto;">
                    <tr>
                      <td style="text-align: center;">
                        <img src="http://www.silverempo.com/assets/images/logo1.png" alt="" width="300px">
                      </td>
                    </tr>
                     <tr>
                      <td><br>
                        <p><strong>Dear Customer,</strong></p>
                        <p>We thank you to connect with Silver Emporium Pvt Ltd. <br>We shall get back to you soon for your query. <br><br>Regards, <br>Team Silver Emporium</p>
                      </td>
                    </tr>
                     <tr>
                      <td style="text-align: center;"><br><hr>
                        <a href="https://www.facebook.com/SilverEmporiumindia"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/facebook.png" border="0"></a>&nbsp;
                        <a href="https://www.instagram.com/silverempoguild/"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/instagram.png" border="0"></a>&nbsp;
                        
                      </td>
                    </tr>
                </table>';

    // Get full html:
    $body = '<!DOCTYPE html>
                <html lang="en">
                <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                  
                  <title> . html_escape($subject) .</title>
                  <link href="https://fonts.googleapis.com/css?family=Roboto&display=swap" rel="stylesheet">
                  <style>p{font-family: "Roboto", sans-serif; font-size: 18px; color: #767676; line-height: 24px; letter-spacing: 1px}</style>
                </head>
                <body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to($email)
      //->cc('email1,email2')
      ->subject($subject)
      ->message($body)
      ->send();

       //echo($this->email->print_debugger()); die() ;
       //echo $body;     


}
public function send_confirmation_mail_to_admin($newCareerDetails, $fileName)
{
      $this->load->library('email');

    $subject = 'New Appilcation From :-' .$newCareerDetails['name'];
    $message = '<center>
        <a href="http://www.silverempo.com/" target="_blank"><img src="http://www.silverempo.com/assets/images/logo1.png" alt="Silver  Emporium Logo" style="max-width: 250px; display: block; margin-left: auto; margin-right: auto;"></a>
        <div style="width: 700px; background-color: #fc7f7f ; color: #fff;  padding-left: 10px; padding-top: 10px; padding-bottom:  10px; padding-right: 10px; border-radius: 5px; text-align: center; margin-top: 10px;">
            <h3>New User Application</h3>
        </div>
            <div style="width: 700px; background-color: #f7f7f7;  padding-left: 10px; padding-right: 10px; border-radius: 5px;">
            <p style="font-size: 17px; font-weight: 600; text-align: justify; margin-top: 0px; padding-top:  15px; ">Dear Admin,</p>
            <p style="font-size: 17px; text-align: justify;">Greetings from <a href="http://www.silverempo.com/" target="_blank" style="text-decoration: none;"><span style="color: #ef4581;"><strong>Silver Emporium</strong></span></a>,</p>
            <p style="font-size: 17px; text-align: justify;">There is a  New User Application, details of User are given as below,</p>
            <table id="customers" style=" border-collapse: collapse; width: 85%;">
            <tr>
                <th class="header-th" colspan="2" style="text-align: center;  padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #fc7f7f; color: #fff;">Personal Details</th>
             </tr>
              <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Name</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['name'].'</td>
              </tr>
              <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Email</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['email'].'</td>
              </tr>
               <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Contact Number</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['contact'].'</td>
              </tr>
               <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Qualification</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['qualification'].'</td>
              </tr>
               <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Address</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['address'].'</td>
              </tr>
              <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Position Applying for</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['position'].'</td>
              </tr>
               <tr>
                <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">City</th>
                <td style="border: 1px solid #ddd; padding: 8px;">'.$newCareerDetails['city'].'</td>
              </tr>
              <tr>
                <td style="align-content: center; border: 1px solid #ddd; padding: 8px; text-align:center" colspan="2" ><a href=https://www.silveremporium.in/assets/resumes/'.$fileName.'"><button style="width: 160px; height: 40px; background:#fc7f7f; color: #fff; border-color: #fc7f7f; border-radius: 3px; font-size: 15px;">See Resume</button></a></td>
              </tr>
            </table>
            <p style="font-size: 17px; text-align: justify; margin-top: 10px; padding-bottom: 15px;">Thank you.</p>
        </div>
    </center>
                ';

    // Get full html:
    $body = '<!DOCTYPE html>
                <html>
                <head>
                    <title>Silver Email</title>
                    <link href="https://fonts.googleapis.com/css?family=Raleway&display=swap" rel="stylesheet">
                    <style>
                    body {
                        font-family: "Raleway", sans-serif;
                    }       

                #customers tr:nth-child(even){background-color: #f2f2f2;}

                #customers tr:hover {background-color: #ddd;}
                </style>
                </head>
                <body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      //->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to('info@silverempo.com')
      //->cc('email1,email2')
      ->subject($subject)
      ->message($body)
      ->send();

       // $mail_send = $this->email->print_debugger();
       // die();
       //echo $body; die();
}

public function terms_and_condition()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Terms and Condition | Policies";
    $data['meta_description']   = "This is a legal agreements between silver emporium and a person who wants to use that service";
    $data['meta_keywords']      = "silver emporium, india's best silverware, silver jewellery, silverware, showpieces in silver, silverware manufacturer";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    $data['view_module'] = "about";
    $data['view_file'] = "terms_and_condition";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);

    
}




}