<?php
class Accounts extends MX_Controller 
{

function __construct() {
parent::__construct();

$this->load->library('form_validation');
$this->form_validation->CI =& $this;

}

function _get_user_name($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $user_name = "Unknown";
  } else {
    $fname = trim($data['first_name']);
    $lname = trim($data['last_name']);

    $user_name = $fname.' '.$lname;
  }

  return $user_name;
}


function _get_user_email($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $user_email = "Unknown";
  } else {
    $user_email = trim($data['email']);
    
  }

  return $user_email;
}

//logout
function logout()
{
  unset($_SESSION['user_id']);
  $this->load->module('site_cookies');
  $this->site_cookies->_destroy_cookie();
  redirect(base_url());
}

//login_page
function login()
{
  //SEO
    $data['meta_title'] = "Silver Emporium | Login | Oxidised Silver Products";
    $data['meta_description'] = "By login into silver emporium website we give you the glance of amazing silver articles, home decor, pooja articles and many more products with all the reasonable prices";
    $data['meta_keywords'] = "online silver gifts, wedding gifts, silver gifts, pure silver products, corporate gifts";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";
    if($this->session->userdata('user_id'))
    {
     redirect('accounts/welcome/');
    }
    else
    {
        $data['email'] = $this->input->post('email', TRUE);
        //$data['pword'] = $this->input->post('pword', TRUE);
        $data['view_file'] = "login";
        $this->load->module('templates');
        $this->templates->public_bootstrap($data);   
    }
}

function submit_login()
{
  $submit = $this->input->post('submit', TRUE);

  if ($submit=="Submit") {

      $this->load->library('form_validation');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[5]|max_length[50]|callback_username_check');
      $this->form_validation->set_rules('pword', 'Password', 'trim|required|max_length[35]');

      if ($this->form_validation->run() == TRUE){
        //figure out the user id
        $col1 = 'email';
        $value1 = $this->input->post('email', TRUE);
        $col2 = 'email';
        $value2 = $this->input->post('email', TRUE);

        $query = $this->get_with_double_condition($col1, $value1, $col2, $value2);

        foreach ($query->result() as $row) {
          $user_id = $row->id;

        }

        $remember = $this->input->post('remember', TRUE);
        if ($remember=="remember-me") {
          $login_type = "longterm";
        } else {
          $login_type = "shortterm";
        }

        //send to the private page
        $this->_in_you_go($user_id, $login_type);

      } else {

        $this->login();
      }
  }
}

function _in_you_go($user_id, $login_type)
{
    $url = null;
    if($this->session->userdata('url'))
    {
        $url = $this->session->userdata('url');  
        $this->session->unset_userdata('url');
    }

  if ($login_type=="longterm") {
    //set a cookie
    $this->load->module('site_cookies');
    $this->site_cookies->_set_cookie($user_id);
    $this->session->set_userdata('user_id', $user_id);
  } else {
    //set a session variable
    $this->session->set_userdata('user_id', $user_id);
  }

  //send the user to the private page
  if($url == null)
  {
    redirect('accounts/welcome/');
  }
  else
  {
    redirect($url);
  }
}


//callback_username_check
function username_check($str)
{

    $this->load->module('accounts');
    $this->load->module('site_security');

    $error_msg = "You didnot Enter Correct Email and/or Password";

    $col1 = 'email';
    $value1 = $str;

    $col2 = 'email';
    $value2 = $str;

    $query = $this->accounts->get_with_double_condition($col1, $value1, $col2, $value2);

    $num_rows = $query->num_rows();

    if ($num_rows<1) {
      $this->form_validation->set_message('username_check', $error_msg);
      return FALSE;
    }

    foreach ($query->result() as $row) {
      $pword_on_table = $row->pword;
    }
    $pword = $this->input->post('pword', TRUE);
    $result = $this->site_security->_verify_hash($pword, $pword_on_table);

    if ($result==TRUE) {
      return TRUE;
    } else {
      $this->form_validation->set_message('username_check', $error_msg);
      return FALSE;
    }

  }

public function register()
{
  

    $this->load->module('accounts');
    $data = $this->fetch_data_from_post();
    $data['flash'] = $this->session->flashdata('item');

    //SEO
    $data['meta_title'] = "Silver Emporium | Register Your Account";
    $data['meta_description'] = "By login into silver emporium website we give you the glance of amazing silver articles, home decor, pooja articles and many more products with all the reasonable prices";
    $data['meta_keywords'] = "online silver gifts, corporate gifts, wedding gifts, silver gifts, pure silver products";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";
    
    $data['view_file'] = "register";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}

function submit()
{
  $submit = $this->input->post('submit', TRUE);

  if ($submit=="Submit") {

      $this->load->library('form_validation');



      $this->form_validation->set_rules('email', 'Email ID', 'trim|required|valid_email|is_unique[accounts.email`]',array(
                'required'      => 'Please Enter Your %s.',
                'is_unique'     => 'This %s already exists. Please use another One'
        ));
      $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|max_length[35]',array(
                'required'      => 'Please Enter Your %s.',
        ));
      $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|max_length[35]',array(
                'required'      => 'Please Enter Your %s.',
        ));
      $this->form_validation->set_rules('pword', 'Password', 'trim|required|max_length[35]',array(
                'required'      => 'Please Enter Your %s.',
        ));
      $this->form_validation->set_rules('conf_pword', 'Confirm Password', 'trim|required|matches[pword]',array(
                'required'      => 'Please Enter Your %s.',
        ));
      $this->form_validation->set_rules('mobile', 'Mobile', 'trim|required|max_length[35]',array(
                'required'      => 'Please Enter Your %s.',
        ));

      $this->form_validation->set_rules('address', 'Address', 'trim|required',array(
                'required'      => 'Please Enter Your %s .',
        ));
      $this->form_validation->set_rules('zip', 'Zip', 'trim|required',array(
                'required'      => 'Please Enter Your %s .',
        ));
      $this->form_validation->set_rules('state', 'State', 'trim|required',array(
                'required'      => 'Please Enter Your %s .',
        ));

      $this->form_validation->set_rules('tnc','Terms and Condition','required', array(
                'required' => 'You Cant proceed Without accepting %s.'
        ));




      if ($this->form_validation->run() == TRUE){



        $this->_process_create_account();
        //redirect('accounts/login');
        $col1 = 'email';
        $value1 = $this->input->post('email', TRUE);
        $col2 = 'email';
        $value2 = $this->input->post('email', TRUE);

        $query = $this->get_with_double_condition($col1, $value1, $col2, $value2);

        foreach ($query->result() as $row) {
          $user_id = $row->id;

        }

        $remember = $this->input->post('remember', TRUE);
        if ($remember=="remember-me") {
          $login_type = "longterm";
        } else {
          $login_type = "shortterm";
        }

        //send to the private page
        $this->_in_you_go($user_id, $login_type);

      



      } else {

        $this->register();
      }
  }
}

function _process_create_account()
{

  $this->load->module('accounts');
  $this->load->module('site_security');
  $data = $this->fetch_data_from_post();
  unset($data['conf_pword']);
  $data['date_created'] = time();
  $data['code'] = $this->site_security->generate_random_string(10);


  $pword = $data['pword'];
  $this->load->module('site_security');
  $data['pword'] = $this->site_security->_hash_string($pword);
  $this->accounts->_insert($data);
}


function welcome()
{
  //SEO
  $data['meta_title'] = "Silver Emporium | Welcome | Online Silver Articles";
  $data['meta_description'] = "we in silver enporium give you the glance of amazing silver articles, home decor, pooja articles and many more products with all the reasonable prices";
  $data['meta_keywords'] = "online silver gifts, wedding gifts, silver gifts, pure silver products, silver corporate gifts";
  $data['image_path']         = "assets/images/about/";
  $data['image']              = "silver-emporium.jpg";

  $this->load->module('site_security');
  $this->site_security->_make_sure_logged_in();
  $user_id = $this->session->userdata('user_id');


  $data['flash'] = $this->session->flashdata('item');
  $data['view_file'] = "welcome";
  $this->load->module('templates');
  $this->templates->public_bootstrap($data);
}

function fetch_data_from_post()
{

  $data['first_name'] = $this->input->post('first_name', TRUE);
  $data['last_name'] = $this->input->post('last_name', TRUE);
  $data['email'] = $this->input->post('email', TRUE);
  $data['mobile'] = $this->input->post('mobile', TRUE);
  $data['pword'] = $this->input->post('pword', TRUE);
  $data['address'] = $this->input->post('address', TRUE);
  $data['address_two'] = $this->input->post('address_two', TRUE);
  $data['city'] = $this->input->post('city', TRUE);
  $data['state'] = $this->input->post('state', TRUE);
  $data['zip'] = $this->input->post('zip', TRUE);
  $data['date_created'] = $this->input->post('date_created', TRUE);

  return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
      $data['first_name'] = $row->first_name;
      $data['last_name'] = $row->last_name;
      $data['email'] = $row->email;
      $data['mobile'] = $row->mobile;
      $data['pword'] = $row->pword;
      $data['address'] = $row->address;
      $data['address_two'] = $row->address_two;
      $data['city'] = $row->city;
      $data['state'] = $row->state;
      $data['zip'] = $row->zip;
      $data['code'] = $row->code;
      $data['status'] = $row->status;
      $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function fetch_data_for_mail($email)
{

    
    $query = $this->get_where_email($email);
    foreach($query->result() as $row)
    {
      $data['fname'] = $row->fname;
      $data['lname'] = $row->lname;
      $data['email'] = $row->email;
      $data['mobile'] = $row->mobile;
      $data['pword'] = $row->pword;
      $data['designation'] = $row->designation;
      $data['institute'] = $row->institute;
      $data['city'] = $row->city;
      $data['state'] = $row->state;
      $data['zip'] = $row->zip;
      $data['code'] = $row->code;
      $data['status'] = $row->status;
      $data['date_created'] = $row->date_created;

    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

public function manage()
{
    $this->load->module('site_security');
    $this->site_security->_make_sure_is_admin();

    $data['flash'] = $this->session->flashdata('Accounts');

    $data['query'] = $this->get('id');
    $data['headline'] = "Account Registered";

    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}

function _get_user_code($email)
{
  $data = $this->fetch_data_for_mail($email);
  if ($data==""){
    $user_code = "Unknown";
  } else {
    $code = trim($data['code']);

    $user_code = $code;
  }

  return $user_code;
}

function _get_user_full_name_from_email($email)
{
  $data = $this->fetch_data_for_mail($email);
  if ($data==""){
    $user_name = "Unknown";
  } else {
    $fname = trim($data['fisrt_name']);
    $lname = trim($data['last_name']);

    $user_name = $fname.' '.$lname;
  }

  return $user_name;
}


public function forgot_password()
{
  $submit = $this->input->post('submit', TRUE);

  if ($submit=="Submit") {

      $this->load->library('form_validation');
      $email = $this->input->post('email', TRUE);



      $this->form_validation->set_rules('email', 'Email ID', 'trim|required|valid_email',array(
                'required'      => 'Please Enter Your %s.',
        ));

      if ($this->form_validation->run() == TRUE){
        //Check Email Exist in Database or not
        $check_email = $this->check_email_already_exists($email);

        if ($check_email == FALSE) {
         
          //If email Exists Send verification
          $this->send_forgot_password_link($email);

          $flash_msg = "Please check your email id to reset password";
          $value = '<div class="alert alert-success alert-dismissible fade show"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
          $this->session->set_flashdata('item', $value);
          redirect('accounts/forgot-password');

        } else {
          //Email id not Exists
          $flash_msg = "Email id you entered does not exists.";
          $value = '<div class="alert alert-danger alert-dismissible fade show"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
          $this->session->set_flashdata('item', $value);
          redirect('accounts/forgot-password');
        }

        


      }

    }

  $data['flash'] = $this->session->flashdata('item');
  $data['module'] = "accounts";
  $data['view_file'] = "forgot_password";
  $this->load->module('templates');
  $this->templates->public_bootstrap($data);
}

//Check Email Exists in database or not
public function check_email_already_exists($email)
{
  $mysql_query = "SELECT * FROM `accounts` WHERE `email`='$email' ";
  $result = $this->_custom_query($mysql_query);

  $query = $result->num_rows();
  if($query >0){
    return FALSE;
  } else {
    return TRUE;
  }
}



function get($order_by)
{
    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_with_double_condition($col1, $value1, $col2, $value2)
{
    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get_with_double_condition($col1, $value1, $col2, $value2);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get_where($id);
    return $query;
}

function get_where_email($email)
{

    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get_where_email($email);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Accounts');
    $this->Mdl_Accounts->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Accounts');
    $this->Mdl_Accounts->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Accounts');
    $this->Mdl_Accounts->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Accounts');
    $count = $this->Mdl_Accounts->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Accounts');
    $max_id = $this->Mdl_Accounts->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Accounts');
    $query = $this->Mdl_Accounts->_custom_query($mysql_query);
    return $query;
}

public function send_forgot_password_link($email)
{ 

}

public function send_confirmation_mail_to_user()
{ 

  $this->load->library('email');

    $subject = 'Test Mail from Silver Emporium';
    $message = '<h1>This is test mail</h1>';

    // Get full html:
    $body = '<!DOCTYPE html>
    <html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="x-apple-disable-message-reformatting"> 
        <title>' . html_escape($subject) . '</title>

        <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:200,300,400,600,700,800,900" rel="stylesheet">


    </head>

    <body width="100%" style="margin: 0; padding: 0 !important; mso-line-height-rule: exactly; background-color: #222222;">
            ' . $message . '
          </center>
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to('kumar_rahul2080@yahoo.com')
      //->cc('email1,email2')
      ->subject($subject)
      ->message($body)
      ->send();

       $mail_send = $this->email->print_debugger() ;
       echo $mail_send;


      


}

}