<?php
class Add_blogs extends MX_Controller
{

function __construct() {
parent::__construct();

}


public function check_admin_or_user()
{
    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
}



//Create Item
function create()
{
    $this->check_admin_or_user();
    $update_id = $this->uri->segment(3);
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('add-blogs/manage');
    }

    if ($submit=="Submit") {

        $this->load->library('form_validation');
        $this->form_validation->set_rules('meta_title', 'Title', 'trim|required', array(
          'required'      => 'Please Enter %s of the Blog.',

        ));

        $this->form_validation->set_rules('meta_keywords', 'keywords', 'trim|required', array(
          'required'      => 'Please Enter %s of the Blog.',
        ));

        $this->form_validation->set_rules('meta_description', 'description', 'trim|required', array(
          'required'      => 'Please Enter %s of the Blog.',
        ));

        $this->form_validation->set_rules('meta_keywords', 'keywords', 'trim|required', array(
          'required'      => 'Please Enter %s of the Blog.',
        ));


        $this->form_validation->set_rules('tags', 'Tags', 'trim|required', array(
          'required'      => 'Please Enter %s of the Blog.',
        ));

        $this->form_validation->set_rules('body', 'Content', 'trim|required', array(
          'required'      => 'Please Enter some %s of the Blog.',
        ));



        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            $data['slug'] = url_title(strtolower($data['meta_title']));
            //$data['image'] = $this->do_upload();

            if (is_numeric($update_id)) {
              //$data['date_created'] = time();
             
               //update a item
                $this->_update($update_id, $data);
                $flash_msg = "The Blog Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-blogs/create/'.$update_id);

            } else {
                $data['image'] = $this->do_upload();
                $data['date_created'] = time();
                $data['category_id'] = implode(",", $data['category_id']); 
                //insert new item
                $this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item


                $flash_msg = "The Blog Successfully Added   .";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-blogs/create/'.$update_id);
            }

        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add Blogs";
    } else {

        $data['headline'] = "Update Blogs";
    }
    
    $this->load->module('blogs_category');
    $data['get_blog_category'] = $this->blogs_category->get_where_custom('status', 1);

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_blogs";
    $data['view_file'] = "new";
    $this->load->module('templates');
    $this->templates->admin($data);
}


//Upload Image
public function do_upload()
{
        $config['upload_path']          = './assets/images/blogs/';
        $config['allowed_types']        = 'gif|jpg|png|jpeg';
        $config['max_size']             = 10000;
        $config['max_width']            = 1920;
        $config['max_height']           = 1080;

        $this->load->library('upload', $config);

        if ( ! $this->upload->do_upload('userfile'))
        {
                $error = array('error' => $this->upload->display_errors());

                $this->load->view('upload_form', $error);
        }
        else
        {

            $data = array('upload_data' => $this->upload->data());
            $upload_data = $data['upload_data'];
            $file_name = $upload_data['file_name'];
            $image = $file_name;
            return $image;


        }
}

function change_image($update_id)
{
    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }

    $update_id = $this->uri->segment(3);
    $this->check_admin_or_user();

    $data['headline'] = "Upload Image";

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_blogs";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function do_change_image($update_id)
{

  if (!is_numeric($update_id)) {
    redirect('site_security/not_allowed');
  }


  $submit = $this->input->post('submit', TRUE);
  $this->check_admin_or_user();


  $config['upload_path']              = './assets/images/blogs/';
  $config['allowed_types']            = 'gif|jpg|jpeg|png';
  $config['max_size']                 = 100000;
  $config['max_width']                = 1920;
  $config['max_height']               = 1080;

  $this->load->library('upload',$config);

  if (!$this->upload->do_upload('userfile')) {


    $data['error'] = array('error'=>$this->upload->display_errors("<p style='color:red'>","</p>"));

    $data['headline'] = "Upload Error";

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_blogs";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);

  } else {

    $data = array('upload_data' => $this->upload->data());
    $data['headline'] = "Upload Success";

    $data['update_id'] = $update_id;
    $upload_data = $data['upload_data'];
    $file_name = $upload_data['file_name'];
    
    //Sending images to database
    $update_data['image'] = $file_name;
    $this->_update($update_id, $update_data);
    $flash_msg = "The Image Successfully Updated.";
    $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
    $this->session->set_flashdata('item', $value);
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_blogs";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);

    $this->load->view('change_image', $data);
  }
}

//Manage Abstract Type
function manage()
{
    $this->check_admin_or_user();
    $data['headline'] = "Blogs";
    $data['flash'] = $this->session->flashdata('item');

    $data['query'] = $this->get_where_custom('status', 1);
    $data['create_blogs'] = base_url()."add-blogs/create";
    $data['edit'] = base_url()."add-blogs/create/";

    $data['view_module'] = "add_blogs";
    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}



function fetch_data_from_post()
{
    $data['meta_title'] = $this->input->post('meta_title', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['meta_keywords'] = $this->input->post('meta_keywords', TRUE);
    $data['meta_description'] = $this->input->post('meta_description', TRUE);
    $data['tags'] = $this->input->post('tags', TRUE);
    $data['category_id'] = $this->input->post('category_id', TRUE);
    $data['body'] = $this->input->post('body', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['tags'] = $row->tags;
        $data['category_id'] = $row->category_id;
        $data['body'] = $row->body;
        $data['image'] = $row->image;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function get($order_by)
{
    $this->load->model('Mdl_Add_blogs');
    $query = $this->Mdl_Add_blogs->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by)
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_blogs');
    $query = $this->Mdl_Add_blogs->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_blogs');
    $query = $this->Mdl_Add_blogs->get_where($id);
    return $query;
}

function get_where_custom($col, $value)
{
    $this->load->model('Mdl_Add_blogs');
    $query = $this->Mdl_Add_blogs->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Add_blogs');
    $this->Mdl_Add_blogs->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_blogs');
    $this->Mdl_Add_blogs->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_blogs');
    $this->Mdl_Add_blogs->_delete($id);
}

function count_where($column, $value)
{
    $this->load->model('Mdl_Add_blogs');
    $count = $this->Mdl_Add_blogs->count_where($column, $value);
    return $count;
}

function get_max()
{
    $this->load->model('Mdl_Add_blogs');
    $max_id = $this->Mdl_Add_blogs->get_max();
    return $max_id;
}

function _custom_query($mysql_query)
{
    $this->load->model('Mdl_Add_blogs');
    $query = $this->Mdl_Add_blogs->_custom_query($mysql_query);
    return $query;
}

//Delete add_blogs
function delete($id)
{


        $this->check_admin_or_user();
        $id = $this->uri->segment(3);
        $this->_delete($id);
        $flash_msg = "The Blog Successfully Deleted.";
        $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
        $this->session->set_flashdata('item', $value);
        $data['flash'] = $this->session->flashdata('item');

      redirect('add-blogs/manage');

}

}
