<?php
class Add_news extends MX_Controller
{

function __construct() {
parent::__construct();





}


function check_admin_or_user()
{
   $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
}


//Create Item
function create()
{

    $this->check_admin_or_user();
    $update_id = $this->uri->segment(3);
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('add-news/manage');
    }

    if ($submit=="Submit") {
        $newNewsDetails = $this->input->post();
        //print_r($newNewsDetails); exit();
        //print_r($this->input->post()); exit();
        $this->load->library('form_validation');
        $this->form_validation->set_rules('meta_title', 'Title', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',

        ));

         $this->form_validation->set_rules('type', 'Type Of News', 'required', array(
          'required'      => 'Please Enter %s of the News.',

        ));



        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            //$data['image'] = $this->do_upload();
            //print_r($data); exit();
            if (is_numeric($update_id)) 
            {
                //$data['slug'] = url_title(strtolower($newNewsDetails['meta_title']));
               //update a item
               if($newNewsDetails['type'] == 'custom')
                    {
                        $this->_update_custom($update_id, $data);
                        
                    }
                    else
                    {
                        $data['slug'] = url_title(strtolower($data['meta_title']));
                        $data['date_created'] = time();
                        $this->_update($update_id, $data);   
                    }
                $flash_msg = "The News Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-news/create/'.$update_id);

            } else {
                $data['image'] = $this->do_upload();
                if($data['type'] == 'custom')
                    {
                        $data['date_created'] = strtotime($newNewsDetails['date']);
                        $this->_insert_custom($data);
                        
                    }
                    else
                    {
                        $data['slug'] = url_title(strtolower($data['meta_title']));
                        $data['date_created'] = time();
                        $this->_insert($data);    
                    }
                //insert new item
                //$this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item


                $flash_msg = "The News Successfully Added   .";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-news/create/'.$update_id);
            }

        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add News";
    } else {

        $data['headline'] = "Update News";
    }
    

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_news";
    $data['view_file'] = "new";
    $this->load->module('templates');
    $this->templates->admin($data);
}


public function create_manual()
{
    $this->check_admin_or_user();
    $this->load->model('Mdl_Add_news');
    
    $update_id = $this->uri->segment(3);
    $data['headline'] = "Add Manual News";
    $data['flash'] = $this->session->flashdata('item');
    $data['newsDetails'] = $this->Mdl_Add_news->get_news_details($update_id);
    $data['view_module'] = "add_news";
    $data['view_file'] = "newmanual";
    $this->load->module('templates');
    $this->templates->admin($data);
}

public function create_custom()
{
    $this->check_admin_or_user();
    $this->load->model('Mdl_Add_news');
    $update_id = $this->uri->segment(3);
    $data['headline'] = "Add Custom News";
    $data['flash'] = $this->session->flashdata('item');
    $data['newsDetails'] = $this->Mdl_Add_news->get_news_details($update_id);
    $data['view_module'] = "add_news";
    $data['view_file'] = "newcustom";
    $this->load->module('templates');
    $this->templates->admin($data);
}

function submit_news()
{
    $this->check_admin_or_user();
    $this->load->model('Mdl_Add_news');
    $newNewsDetails = $this->input->post();
    if($this->uri->segment(3) == '')
    {
        $fileName = '';
    $this->load->library('form_validation');
        $this->form_validation->set_rules('meta_title', 'Title', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',

        ));

     $this->form_validation->set_rules('meta_keywords', 'keywords', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',
        ));

        $this->form_validation->set_rules('meta_description', 'description', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',
        ));
        $this->form_validation->set_rules('body', 'Content', 'trim|required', array(
          'required'      => 'Please Enter some %s of the News.',
       ));
    if($this->form_validation->run())
        {
                //print_r($newNewsDetails);        
            $config = array(
            'upload_path' => './assets/images/news/',
            'allowed_types' => 'jpg|jpeg|png|PNG|JPEG|JPG',
            'max-size' =>4000,
            'filename' => $this->input->post('file')
            );
            $this->load->library('upload', $config);
            $uploadFile =  $this->upload->do_upload('file');
            if($uploadFile)
            {
              $data = $this->upload->data();
              $fileName = $data['file_name'];
              //echo $fileName; die();
              $this->Mdl_Add_news->add_manual_news($newNewsDetails,$fileName);
              $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'News added successfully !!'.'</p>');
              redirect('add-news/create-manual');
            }
            else
            {
               $error = $this->upload->display_errors();
               //print_r($error); exit();
               $this->session->set_flashdata('reply', '<div class="alert alert-danger"><p> ' .$error.' </p></div>');
                $this->create_manual();
               //print_r($error); exit();
            }
        }
        else
        {
            $this->create_manual();
             //echo "problem";
        }
    }
    else
    {
        $id = $this->uri->segment(3);
        $this->Mdl_Add_news->update_manual_news($newNewsDetails,$id);
        $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'News Updated successfully !!'.'</p>');
        redirect('add-news/create-manual/'.$id);
    }
    //print_r($newNewsDetails);
    //cho "string";
}

function submit_custom()
{
    //echo "ala ka";
    $this->check_admin_or_user();
    $this->load->model('Mdl_Add_news');
    $newNewsDetails = $this->input->post();
    if($this->uri->segment(3) == '')
    {
        $fileName = '';
    $this->load->library('form_validation');
    $this->form_validation->set_rules('meta_title', 'Title', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',

        ));
    $this->form_validation->set_rules('slug', 'News Link', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',
        ));
    $this->form_validation->set_rules('date', 'News Date', 'trim|required', array(
          'required'      => 'Please Enter %s of the News.',
        ));
     if($this->form_validation->run())
        {
                //print_r($newNewsDetails);        
            $config = array(
            'upload_path' => './assets/images/news/',
            'allowed_types' => 'jpg|jpeg|png|PNG|JPEG|JPG',
            'max-size' =>4000,
            'filename' => $this->input->post('file')
            );
            $this->load->library('upload', $config);
            $uploadFile =  $this->upload->do_upload('file');
            if($uploadFile)
            {
              $data = $this->upload->data();
              $fileName = $data['file_name'];
              //echo $fileName; die();
              $this->Mdl_Add_news->add_custom_news($newNewsDetails,$fileName);
              $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'News added successfully !!'.'</p>');
              redirect('add-news/create-custom');
            }
            else
            {
               $error = $this->upload->display_errors();
               //print_r($error); exit();
               $this->session->set_flashdata('reply', '<div class="alert alert-danger"><p> ' .$error.' </p></div>');
                $this->create_custom();
               //print_r($error); exit();
            }
        }
        else
        {
            $this->create_custom();
             //echo "problem";
        }
    }
    else
    {
        //print_r($newNewsDetails);
        $id = $this->uri->segment(3);
        $this->Mdl_Add_news->update_custom_news($newNewsDetails,$id);
        $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'News Updated successfully !!'.'</p>');
        redirect('add-news/create-custom/'.$id);
    }
}


function change_news_image()
{ 
    $this->check_admin_or_user();
    $update_id = $this->uri->segment(3);
    $data['headline'] = "Update News Image";
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_news";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);
}

//Upload Image
public function do_upload()
{
        $config['upload_path']          = './assets/images/news/';
        $config['allowed_types']        = 'gif|jpg|png|jpeg';
        $config['max_size']             = 10000;
        $config['max_width']            = 1920;
        $config['max_height']           = 1080;

        $this->load->library('upload', $config);

        if ( ! $this->upload->do_upload('file'))
        {
                $error = array('error' => $this->upload->display_errors());

                $this->load->view('upload_form', $error);
        }
        else
        {

            $data = array('upload_data' => $this->upload->data());
            $upload_data = $data['upload_data'];
            $file_name = $upload_data['file_name'];
            $image = $file_name;
            return $image;


        }
}

function change_image($update_id)
{
    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }

    $this->check_admin_or_user();
    $update_id = $this->uri->segment(3);

    $data['headline'] = "Upload Image";

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_news";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function do_change_image()
{
    $this->check_admin_or_user();
    //echo $this->uri->segment(3);
    $this->load->model('Mdl_Add_news');
    $config = array(
            'upload_path' => './assets/images/news/',
            'allowed_types' => 'jpg|jpeg|png|PNG|JPEG|JPG',
            'max-size' =>4000,
            'filename' => $this->input->post('file')
            );
            $this->load->library('upload', $config);
            $uploadFile =  $this->upload->do_upload('file');
            if($uploadFile)
            {
              $data = $this->upload->data();
              $fileName = $data['file_name'];
              //echo $fileName; die();
              $id = $this->uri->segment(3);
              $this->Mdl_Add_news->update_news_image($fileName,$id);
              $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'News Image Updated successfully !!'.'</p>');
              redirect('add-news/create-custom/'.$this->uri->segment(3));
            }
            else
            {
               $error = $this->upload->display_errors();
               //print_r($error); exit();
               $this->session->set_flashdata('reply', '<div class="alert alert-danger"><p> ' .$error.' </p></div>');
               redirect('add-news/change-news-image/'.$this->uri->segment(3));
               //print_r($error); exit();
            }
}

//Manage Abstract Type
function manage()
{
    $this->check_admin_or_user();
    $data['headline'] = "News";
    $data['flash'] = $this->session->flashdata('item');

    $data['query'] = $this->get_where_custom('status', 1);
    $data['create_news'] = base_url()."add-news/create";
    $data['edit'] = base_url()."add-news/create/";

    $data['view_module'] = "add_news";
    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}



function fetch_data_from_post()
{
    $data['meta_title'] = $this->input->post('meta_title', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['meta_keywords'] = $this->input->post('meta_keywords', TRUE);
    $data['meta_description'] = $this->input->post('meta_description', TRUE);
    $data['body'] = $this->input->post('body', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);
    $data['type'] = $this->input->post('type', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['body'] = $row->body;
        $data['image'] = $row->image;
        $data['status'] = $row->status;
        $data['type'] = $row->type;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function get($order_by)
{
    $this->load->model('Mdl_Add_news');
    $query = $this->Mdl_Add_news->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by)
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_news');
    $query = $this->Mdl_Add_news->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_news');
    $query = $this->Mdl_Add_news->get_where($id);
    return $query;
}

function get_where_custom($col, $value)
{
    $this->load->model('Mdl_Add_news');
    $query = $this->Mdl_Add_news->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Add_news');
    $this->Mdl_Add_news->_insert($data);
}

function _insert_custom($data)
{
    $this->load->model('Mdl_Add_news');
    $this->Mdl_Add_news->_insert_custom($data);   
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_news');
    $this->Mdl_Add_news->_update($id, $data);
}

function _update_custom($update_id, $data)
{
     $this->load->model('Mdl_Add_news');
    $this->Mdl_Add_news->_update_custom_news($data);   
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_news');
    $this->Mdl_Add_news->_delete($id);
}

function count_where($column, $value)
{
    $this->load->model('Mdl_Add_news');
    $count = $this->Mdl_Add_news->count_where($column, $value);
    return $count;
}

function get_max()
{
    $this->load->model('Mdl_Add_news');
    $max_id = $this->Mdl_Add_news->get_max();
    return $max_id;
}

function _custom_query($mysql_query)
{
    $this->load->model('Mdl_Add_news');
    $query = $this->Mdl_Add_news->_custom_query($mysql_query);
    return $query;
}

//Delete add_news
function delete($id)
{

        $id = $this->uri->segment(3);
        $this->_delete($id);
        $flash_msg = "The News Successfully Deleted.";
        $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
        $this->session->set_flashdata('item', $value);
        $data['flash'] = $this->session->flashdata('item');

      redirect('add-news/manage');

}

}

