<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Mdl_Add_news extends CI_Model
{

function __construct() {
parent::__construct();
}

function get_table() {
    $table = "news";
    return $table;
}

function get($order_by){
    $table = $this->get_table();
    $this->db->order_by($order_by);
    $query=$this->db->get($table);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) {
    $table = $this->get_table();
    $this->db->limit($limit, $offset);
    $this->db->order_by($order_by, "desc");
    $query=$this->db->get($table);
    return $query;
}

function get_where($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $query=$this->db->get($table);
    return $query;
}

function get_where_custom($col, $value) {
    $table = $this->get_table();
    $this->db->where($col, $value);
    $query=$this->db->get($table);
    return $query;
}

function _insert($data){
    //print_r($data); exit();
    $table = $this->get_table();
    $this->db->insert($table, $data);
}

function _insert_custom($data)
{
      // print_r($data); exit();
       $session = $this->session->get_userdata('is_admin');
       $user_id = $session['is_admin'];
       //print_r($user_id); exit();
     //$table = $this->get_table();
         $this->db->insert('news',['meta_title'=>$data['meta_title'],'title'=>$data['meta_title'],'slug'=>$data['slug'],'meta_description'=>'','meta_keywords'=>'','body'=>'','image'=>$data['image'],
            'date_created'=>$data['date_created'],'created_by'=>$user_id,'type'=>$data['type'],'link'=>$data['slug']]);
    }
    //print_r($data); exit();


public function _update_custom_news($update_id,$data)
{
    //print_r($update_id); exit();
    $this->db->set('meta_title', $data['meta_title']); //value that used to update column  
    $this->db->set('title', $data['meta_title']); //value that used to update column  
    $this->db->set('slug', $data['slug']); //value that used to update column  
    $this->db->set('meta_description', '');
    $this->db->set('meta_keywords', '');
    $this->db->set('type', $data['type']);
    $this->db->set('link', $data['slug']);
    $this->db->where('id', $update_id); //which row want to upgrade  
      $this->db->update('news');  //table name    
}

function _update($id, $data){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->update($table, $data);
}

function _delete($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->delete($table);
}

function count_where($column, $value) {
    $table = $this->get_table();
    $this->db->where($column, $value);
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function count_all() {
    $table = $this->get_table();
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function get_max() {
    $table = $this->get_table();
    $this->db->select_max('id');
    $query = $this->db->get($table);
    $row=$query->row();
    $id=$row->id;
    return $id;
}

function _custom_query($mysql_query) {
    $query = $this->db->query($mysql_query);
    return $query;
}

function add_manual_news($newNewsDetails,$fileName)
{
    $session = $this->session->get_userdata('is_admin');
    $user_id = $session['is_admin'];
    $this->db->insert('news',['meta_title'=>$newNewsDetails['meta_title'],'title'=>$newNewsDetails['meta_title'],'slug'=>strtolower(url_title($newNewsDetails['meta_title'])),'meta_description'=>$newNewsDetails['meta_description'],'meta_keywords'=>$newNewsDetails['meta_keywords'],'body'=>$newNewsDetails['body'],'image'=>$fileName,
            'date_created'=>time(),'created_by'=>$user_id,'type'=>'manual','link'=>'NA']);
}

function add_custom_news($newNewsDetails,$fileName)
{

   $session = $this->session->get_userdata('is_admin');
       $user_id = $session['is_admin']; 
    $this->db->insert('news',['meta_title'=>$newNewsDetails['meta_title'],'title'=>$newNewsDetails['meta_title'],'slug'=>strtolower(url_title($newNewsDetails['meta_title'])),'meta_description'=>'','meta_keywords'=>'','body'=>'','image'=>$fileName,
            'date_created'=>strtotime($newNewsDetails['date'].'00:00:00'),'created_by'=>$user_id,'type'=>'custom','link'=>$newNewsDetails['slug']]);
}

function get_news_details($update_id)
{
    $query = $this->db->query("SELECT * FROM `news` WHERE id = '$update_id'");
    return $query->result();   
}

function update_custom_news($newNewsDetails,$id)
{
    if($newNewsDetails['date'] == '')
    {
        $this->db->set('title', $newNewsDetails['meta_title']);
        $this->db->set('meta_title', $newNewsDetails['meta_title']); //value that used to update column  
        $this->db->set('slug', strtolower(url_title($newNewsDetails['meta_title'])));
        $this->db->set('link', $newNewsDetails['slug']);
        $this->db->where('id', $id); //which row want to upgrade  
        $this->db->update('news');  //table name    
    }
    else
    {
        $this->db->set('title', $newNewsDetails['meta_title']); //value that used to update column  
        $this->db->set('meta_title', $newNewsDetails['meta_title']); //value that used to update column  
        $this->db->set('slug', strtolower(url_title($newNewsDetails['meta_title'])));
        $this->db->set('link', $newNewsDetails['slug']);
        $this->db->set('date_created', strtotime($newNewsDetails['date'].'00:00:00'));
        $this->db->where('id', $id); //which row want to upgrade  
        $this->db->update('news');  //table name    
    }
}

function update_manual_news($newNewsDetails,$id)
{
        $this->db->set('title', $newNewsDetails['meta_title']); //value that used to update column  
        $this->db->set('meta_title', $newNewsDetails['meta_title']); //value that used to update column  
        $this->db->set('slug', strtolower(url_title($newNewsDetails['meta_title'])));
        $this->db->set('meta_description', $newNewsDetails['meta_description']);
        $this->db->set('meta_keywords', $newNewsDetails['meta_keywords']);
        $this->db->set('body', $newNewsDetails['body']);
        $this->db->set('link', 'NA');
        $this->db->where('id', $id); //which row want to upgrade  
        $this->db->update('news');  //table name    
}

function update_news_image($fileName,$id)
{
    $this->db->set('image', $fileName);
    $this->db->where('id', $id); //which row want to upgrade  
    $this->db->update('news');  //table name       
}




}
