<?php
class Add_products extends MX_Controller 
{

function __construct() {
parent::__construct();


    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
}


public function bulk_upload()
{
  $data['flash'] = $this->session->flashdata('item');
  $data['view_module'] = "products";
  $data['view_file'] = "bulk_upload";
  $this->load->module('templates');
  $this->templates->admin($data);
}

public function upload_data()
{
    $update_id = $this->get_max();
    if ($this->input->post('submit')) {
            
            $path = 'uploads/';
            require_once APPPATH . "/third_party/PHPExcel.php";
            $config['upload_path'] = $path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['remove_spaces'] = TRUE;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);            
            if (!$this->upload->do_upload('uploadFile')) {
                $error = array('error' => $this->upload->display_errors());
            } else {
                $data = array('upload_data' => $this->upload->data());
            }
            if(empty($error)){
              if (!empty($data['upload_data']['file_name'])) {
                $import_xls_file = $data['upload_data']['file_name'];
            } else {
                $import_xls_file = 0;
            }
            $inputFileName = $path . $import_xls_file;
            
            try {
                $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($inputFileName);
                $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                $flag = true;
                $i=0;
                foreach ($allDataInSheet as $value) {
                  if($flag){
                    $flag =false;
                    continue;
                  }
                  $inserdata[$i]['category'] = str_replace('_', '-', $value['B']);
                  $inserdata[$i]['subcategory'] = $value['C'];
                  $inserdata[$i]['name'] = $value['D'];
                  $inserdata[$i]['purity'] = $value['E'];
                  $inserdata[$i]['polished'] = $value['F'];
                  $inserdata[$i]['gross_weight'] = $value['G'];
                  $inserdata[$i]['piece'] = $value['H'];
                  $inserdata[$i]['image'] = $value['I'];
                  $inserdata[$i]['location'] = $value['J'];
                  $inserdata[$i]['details'] = $value['K'];
                  $inserdata[$i]['price'] = $value['L'];
                  $code_new = $value['M'];
                  $code_add = ($code_new.($update_id++));
                  $inserdata[$i]['code'] = $code_add;
                  $inserdata[$i]['meta_description'] = $value['N'];
                  $inserdata[$i]['meta_keywords'] = $value['O'];
                  $inserdata[$i]['tags'] = $value['P'];
                  $inserdata[$i]['electroforming_code'] = $value['Q'];
                  $inserdata[$i]['date_created'] = time();
                  $i++;

                }               
                $result = $this->import->importdata($inserdata);   
                if($result){
                  //echo "Imported successfully";
                  $flash_msg = "The Product Successfully Uploaded.";
  $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
  $this->session->set_flashdata('item', $value);
  

                }else{
                  echo "ERROR !";
                }             
 
          } catch (Exception $e) {
               die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME)
                        . '": ' .$e->getMessage());
            }
          }else{
              echo $error['error'];
            }
            
            
    }
    $this->bulk_upload();
}



function create()
{

    $update_id = $this->uri->segment(3);
    $get_max_id = $this->get_max();
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('add-Products/manage');
    }

    if ($submit=="Submit") {

        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Product Name', 'trim|required', array(
          'required'      => 'Please Enter %s of the Product.',

        ));

        $this->form_validation->set_rules('category', 'Product Category', 'trim|required', array(
          'required'      => 'Please Enter %s of the Product.',
        ));

            $this->form_validation->set_rules('tags', 'Tags', 'trim|required', array(
          'required'      => 'Please Enter %s of the Product.',
        ));

        $this->form_validation->set_rules('meta_keywords', 'Meta Keywords', 'trim|required', array(
          'required'      => 'Please Enter %s of the Product.',
        ));

        $this->form_validation->set_rules('meta_description', 'Meta Descrition', 'trim|required', array(
          'required'      => 'Please Enter %s of the Product.',
        ));

        $this->form_validation->set_rules('code', 'Code ', 'trim|required', array(
          'required'      => 'Please Select %s of the Product.',
        ));




        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            if ($data['subcategory'] == "") {
                $data['subcategory'] = "NoSubcategory";
            }
            //$data['image'] = $this->do_upload();

            if (is_numeric($update_id)) {
              $data['date_created'] = time();
             
               //update a item
                $this->_update($update_id, $data);
                $flash_msg = "The Product Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-Products/create/'.$update_id);

            } else {
                //$data['image'] = $this->do_upload();
                $data['date_created'] = time();
                $code = $this->input->post('code', TRUE);
                $data['code'] = ($code.($get_max_id++));
                //insert new item
                $this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item


                $flash_msg = "The Product Successfully Added   .";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('add-Products/create/'.$update_id);
            }

        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add Products";
    } else {

        $data['headline'] = "Update Products";
    }
    
    // $this->load->module('Products_category');
    // $data['get_Product_category'] = $this->Products_category->get_where_custom('status', 1);

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_products";
    $data['view_file'] = "create";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function change_image($update_id)
{
    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }

    $this->load->library('session');
    $this->load->module('site_security');

    $update_id = $this->uri->segment(3);

    $data['headline'] = "Upload Image";

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_products";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function do_change_image($update_id)
{

  if (!is_numeric($update_id)) {
    redirect('site_security/not_allowed');
  }

  
  $submit = $this->input->post('submit', TRUE);

  if ($submit=="Cancel"){
      redirect('add-products/create/'.$update_id);
    }


  $config['upload_path']              = './assets/images/products/';
  $config['allowed_types']            = 'gif|jpg|jpeg|png';
  $config['max_size']                 = 100000;
  $config['max_width']                = 1920;
  $config['max_height']               = 1080;

  $this->load->library('upload',$config);

  if (!$this->upload->do_upload('userfile')) {


    $data['error'] = array('error'=>$this->upload->display_errors("<p style='color:red'>","</p>"));

    $data['headline'] = "Upload Error";

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_products";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);

  } else {

    $data = array('upload_data' => $this->upload->data());
    $data['headline'] = "Upload Success";

    $data['update_id'] = $update_id;
    $upload_data = $data['upload_data'];
    $file_name = $upload_data['file_name'];
    
    //Sending images to database
    $update_data['image'] = $file_name;
    $this->_update($update_id, $update_data);
    $flash_msg = "The Image Successfully Updated.";
    $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
    $this->session->set_flashdata('item', $value);
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "add_products";
    $data['view_file'] = "change_image";
    $this->load->module('templates');
    $this->templates->admin($data);

    $this->load->view('change_image', $data);
  }
}


function fetch_data_from_post()
{
    $data['category'] = $this->input->post('category', TRUE);
    $data['subcategory'] = $this->input->post('subcategory', TRUE);
    $data['name'] = $this->input->post('name', TRUE);
    $data['meta_title'] = $this->input->post('meta_title', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['purity'] = $this->input->post('purity', TRUE);
    $data['polished'] = $this->input->post('polished', TRUE);
    $data['gross_weight'] = $this->input->post('gross_weight', TRUE);
    $data['piece'] = $this->input->post('piece', TRUE);
    $data['location'] = $this->input->post('location', TRUE);
    $data['details'] = $this->input->post('details', TRUE);
    $data['price'] = $this->input->post('price', TRUE);
    $data['code'] = $this->input->post('code', TRUE);
    $data['electroforming_code'] = $this->input->post('electroforming_code', TRUE);
    $data['meta_keywords'] = $this->input->post('meta_keywords', TRUE);
    $data['meta_description'] = $this->input->post('meta_description', TRUE);
    $data['tags'] = $this->input->post('tags', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['category'] = $row->category;
        $data['subcategory'] = $row->subcategory;
        $data['name'] = $row->name;
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['purity'] = $row->purity;
        $data['polished'] = $row->polished;
        $data['gross_weight'] = $row->gross_weight;
        $data['piece'] = $row->piece;
        $data['location'] = $row->location;
        $data['details'] = $row->details;
        $data['price'] = $row->price;
        $data['code'] = $row->code;
        $data['electroforming_code'] = $row->electroforming_code;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['tags'] = $row->tags;
        $data['image'] = $row->image;        
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}




function manage()
{

    $data['headline'] = "All Products";
    $data['flash'] = $this->session->flashdata('item');

    $data['query'] = $this->get_where_custom('status', 1);
    $data['edit'] = base_url()."add-products/create/";

    $data['view_module'] = "add_products";
    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}

function get($order_by)
{
    $this->load->model('Mdl_Add_products');
    $query = $this->Mdl_Add_products->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_products');
    $query = $this->Mdl_Add_products->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_products');
    $query = $this->Mdl_Add_products->get_where($id);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Add_products');
    $query = $this->Mdl_Add_products->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Add_products');
    $this->Mdl_Add_products->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_products');
    $this->Mdl_Add_products->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Add_products');
    $this->Mdl_Add_products->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Add_products');
    $count = $this->Mdl_Add_products->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Add_products');
    $max_id = $this->Mdl_Add_products->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Add_products');
    $query = $this->Mdl_Add_products->_custom_query($mysql_query);
    return $query;
}

//Delete add_products
function delete($id)
{

        $id = $this->uri->segment(3);
        $this->_delete($id);
        $flash_msg = "The Product Successfully Deleted.";
        $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
        $this->session->set_flashdata('item', $value);
        $data['flash'] = $this->session->flashdata('item');

      redirect('add-products/manage');

}

}