<?php
class Ask_for_quote extends MX_Controller
{

function __construct() {
parent::__construct();
}

    public function index()
    {
        //SEO
        $data['meta_title'] = "Ask for quote | Silver Products Quotes";
        $data['meta_description'] = "Find out the best way to make large purchases to in our guide to buying silver products in bulk. Just fill up detailed quotation for any of our products. Bulk purchases can provide silver at lower price since it cost them less process one larger order or item than several smaller ones";
        $data['meta_keywords'] = "get silver products quote, silver antiques price, silver masterpiece prices, silver emporium gifts at cheap rate";
        $data['cannonical']         = "";
        $data['image_path']         = "assets/images/learning/";
        $data['image']              = "silver-emporium.jpg";

        $data['view_module'] = "ask_for_quote";
        $data['view_file'] = "index";
        $this->load->module('templates');
        $this->templates->public_bootstrap($data);
    }
    public function submit()
    {
        $newQuoteDetails = $this->input->post();
        $fileName = '';
        $this->form_validation->set_rules('f_name','First Name','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
        $this->form_validation->set_rules('l_name','Last Name','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));                                        
        $this->form_validation->set_rules('contact','Contact Number','required|numeric',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'numeric' => '%s should not contain text.'
                                                ));
        $this->form_validation->set_rules('city','City','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
        $this->form_validation->set_rules('email','Email Address','required|valid_email',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'valid_email' =>'%s is not valid.'
                                                    ));
        $this->form_validation->set_rules('pcode','Product Code','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
         $this->form_validation->set_rules('orderquantity','Quanity','required|numeric',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'numeric' => '%s should not contain text.'
                                                ));
        $this->form_validation->set_rules('tnc','Terms and Condition','required', array(
                'required' => 'You Cant proceed Without accepting %s.'
        ));
        
        if($this->form_validation->run())
        {
            $config = array(
                'upload_path' => './assets/quote/',
                'allowed_types' => 'jpg|jpeg|PDF|pdf|JPG|JPEG',
                'max-size' =>5000,
                'filename' => $this->input->post('file')
            );
            $this->load->library('upload', $config);
            $uploadFile =  $this->upload->do_upload('file');
            if($uploadFile)
            {
                $data = $this->upload->data();
                $fileName = $data['file_name'];
            }
            else
            {
                $fileName = "No File Selected";
            }
            $this->load->model('Mdl_Ask_For_Quote');
            $saveQuoteDetails = $this->Mdl_Ask_For_Quote->save_quote_details($newQuoteDetails,$fileName);
            if($saveQuoteDetails)
                {
                    $email = $this->input->post('email', TRUE);
                    $this->send_confirmation_mail_to_user($email);
                    $this->send_confirmation_mail_to_admin($newQuoteDetails,$fileName);
                    $this->session->set_flashdata('success', "Thank you for the details we will get back to you soon !!");
                    redirect('ask_for_quote');
                }
                else
                {
                    $this->session->set_flashdata('not_success', "Data did not store !!");
                    redirect('ask_for_quote');
                }
        }
        else
        {
            $this->index();
        }
    }


    public function manage()
    {
      $this->load->library('session');
      $this->load->module('site_security');
      $this->load->module('users');
      $is_admin = $this->session->userdata('is_admin');
      if ($is_admin == 1) {
        $this->site_security->_make_sure_is_admin();
      } else {
        $this->site_security->_make_sure_logged_in();
        $user_id = $this->site_security->_get_user_id();
        $get_user_role = $this->users->_get_user_role($user_id);
        $b=$get_user_role;
        $user_roles = explode(",",$b);
        $page_role = $this->uri->segment(1);
        if(!in_array($page_role,$user_roles)) {
          $this->site_security->not_allowed_to_access_this_page();
        }
      }

      $data['query'] = $this->get('id');
      $data['headline'] = "Ask for Quotes Query";


      $data['view_file'] = "manage";
      $this->load->module('templates');
      $this->templates->admin($data);
    }


    public function delete()
    {
      $this->load->library('session');
      $this->load->module('site_security');
      $this->load->module('users');
      $is_admin = $this->session->userdata('is_admin');
      if ($is_admin == 1) {
        $this->site_security->_make_sure_is_admin();
      } else {
        $this->site_security->_make_sure_logged_in();
        $user_id = $this->site_security->_get_user_id();
        $get_user_role = $this->users->_get_user_role($user_id);
        $b=$get_user_role;
        $user_roles = explode(",",$b);
        $page_role = $this->uri->segment(1);
        if(!in_array($page_role,$user_roles)) {
          $this->site_security->not_allowed_to_access_this_page();
        }
      }
    
      $id = $this->uri->segment(3);
      $this->load->model('Mdl_Ask_For_Quote');
      $this->Mdl_Ask_For_Quote->delete($id);
      $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Query Removed successfully !!'.'</p>');
      redirect('ask_for_quote/manage');

    }
    

function get($order_by)
{
    $this->load->model('Mdl_Ask_For_Quote');
    $query = $this->Mdl_Ask_For_Quote->get($order_by);
    return $query;
}

public function send_confirmation_mail_to_user($email)
{ 

  $this->load->library('email');

    $subject = 'Thanks for you query in Silver Emporium';
    $message = '<table border="0" style="width: 700px; margin: 0 auto;">
                    <tr>
                      <td style="text-align: center;">
                        <img src="http://www.silverempo.com/assets/images/logo1.png" alt="" width="300px">
                      </td>
                    </tr>
                     <tr>
                      <td><br>
                        <p><strong>Dear Customer,</strong></p>
                        <p>We thank you to connect with Silver Emporium Pvt Ltd. <br>We shall get back to you soon for your query. <br><br>Regards, <br>Team Silver Emporium</p>
                      </td>
                    </tr>
                     <tr>
                      <td style="text-align: center;"><br><hr>
                        <a href="https://www.facebook.com/SilverEmporiumindia"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/facebook.png" border="0"></a>&nbsp;
                        <a href="https://www.instagram.com/silverempoguild/"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/instagram.png" border="0"></a>&nbsp;
                      </td>
                    </tr>
                </table>';

    // Get full html:
    $body = '<!DOCTYPE html>
                <html lang="en">
                <head>
                  <meta charset="UTF-8">
                  <title> . html_escape($subject) .</title>
                  <link href="https://fonts.googleapis.com/css?family=Roboto&display=swap" rel="stylesheet">
                  <style>p{font-family: "Roboto", sans-serif; font-size: 18px; color: #767676; line-height: 24px; letter-spacing: 1px}</style>
                </head>
                <body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to($email)
      //->cc('rrcg.rahulk@gmail.com')
      ->subject($subject)
      ->message($body)
      ->send();

       //$mail_send = $this->email->print_debugger() ;
       //echo $body;     


}

public function send_confirmation_mail_to_admin($newQuoteDetails,$fileName)
{ 

  $this->load->library('email');
  $email = 'info@silverempo.com';
  $file = '';
  if($fileName == 'No File Selected')
  {
    $file = 'nofile.png';
  }
  else
  {
    $file = $fileName;
  }

    $subject = 'You got an Quotation Enquiry in Silver Emporium';
    $message = '
    <center>
    <a href="http://www.silverempo.com/" target="_blank"><img src="http://www.silverempo.com/assets/images/logo1.png" alt="Silver  Emporium Logo" style="max-width: 250px; display: block; margin-left: auto; margin-right: auto;"></a>
    <div style="width: 700px; background-color: #fc7f7f ; color: #fff;  padding-left: 10px; padding-top: 10px; padding-bottom:  10px; padding-right: 10px; border-radius: 5px; text-align: center; margin-top: 10px;">
      <h3>New Enquiry</h3>
    </div>
      <div style="width: 700px; background-color: #f7f7f7;  padding-left: 10px; padding-right: 10px; border-radius: 5px;">
      <p style="font-size: 17px; font-weight: 600; text-align: justify; margin-top: 0px; padding-top:  15px; ">Dear Admin,</p>
      <p style="font-size: 17px; text-align: justify;">Greetings from <a href="http://www.silverempo.com/" target="_blank" style="text-decoration: none;"><span style="color: #ef4581;"><strong>Silver Emporium</strong></span></a>,</p>
      <p style="font-size: 17px; text-align: justify;">There is a  New User Enquiry , details of User  Enquiry is given as below,</p>
      <table id="customers" style=" border-collapse: collapse; width: 85%;">
      <tr>
          <th class="header-th" colspan="2" style="text-align: center;  padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #fc7f7f; color: #fff;">Personal Details</th>
       </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Name</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['f_name']." ".$newQuoteDetails['l_name'].'</td>
        </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Email</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['email'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Contact Number</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['contact'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Quantity</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['orderquantity'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">City</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['city'].'</td>
        </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Product Code</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newQuoteDetails['pcode'].'</td>
        </tr>
          <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Product Image</th>
          <td style="border: 1px solid #ddd; padding: 8px;"><img src="http://localhost/silveremporium/assets/quote/'.$file.'" style="width:150px;"></td>
        </tr>
      </table>
      <p style="font-size: 17px; text-align: justify; margin-top: 10px; padding-bottom: 15px;">Thank you.</p>
    </div>
  </center>
                ';

    // Get full html:
    $body = '
            <!DOCTYPE html>
<html>
<head>
  <title>Ask For Quote Silver Email</title>
  <link href="https://fonts.googleapis.com/css?family=Raleway&display=swap" rel="stylesheet">
  <style>
  body {
    font-family: "Raleway", sans-serif;
  }   

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}
</style>
</head>
<body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to($email)
      //->cc('rrcg.rahulk@gmail.com')
      ->subject($subject)
      ->message($body)
      ->send();

       //$mail_send = $this->email->print_debugger() ;
       //echo $body;    die();


}


}
