<?php
class Blogs extends MX_Controller 
{

function __construct() {
parent::__construct();
}

public function index()
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Blogs | Latest Blogs | Silver New Updates";
    $data['meta_description']   = "Silver Emporium also shares blogs on silver related topics about how to store silver , what to gift and also about many more silver articles. We share our thoughts our experiences for other people to read";
    $data['meta_keywords']      = "silver blogs, silver tips, silver silver news, silver price, latest silver articles, pure silver, 999 silver";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/blogs/";
    $data['image']              = "";
    $this->load->module('blogs');
    
    $use_limit = FALSE;
    $mysql_query = $this->_generate_mysql_query($use_limit);
    $query = $this->_custom_query($mysql_query); 
    $total_blogs = $query->num_rows();


    //Fetch for this Page
    $use_limit = TRUE;
    $mysql_query = $this->_generate_mysql_query($use_limit);

    
    $pagination_data['template'] = 'public_bootstrap';
    $pagination_data['target_base_url'] = $this->get_target_pagination_base_url();
    $pagination_data['total_rows'] = $total_blogs;
    $pagination_data['offset_segment'] = 3;
    $pagination_data['limit'] = $this->get_limit();

    $this->load->module('custom_pagination');
    
    $data['pagination'] = $this->custom_pagination->_generate_pagination($pagination_data);
    $data['blogs'] = $this->_custom_query($mysql_query);

    $data['view_module'] = "blogs";
    $data['view_file'] = "index";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}

function get_target_pagination_base_url()
{
    $first_bit = $this->uri->segment(1);
    $second_bit = $this->uri->segment(2);
    $third_bit = $this->uri->segment(3);

    $target_base_url = base_url().$first_bit."/".'index';

    return $target_base_url;
}

function _generate_mysql_query($use_limit)
{
    $mysql_query= "SELECT * FROM `blogs` WHERE STATUS=1 ORDER BY id desc";
    if ($use_limit==TRUE) {
        $limit = $this->get_limit();
        $offset = $this->get_offset();
        $mysql_query.= " limit ".$offset.", ".$limit;
    }
    return $mysql_query;
}


function get_limit()
{
    $limit = 6;
    return $limit;
}

function get_offset()
{
    $offset = $this->uri->segment(3);
    if (!is_numeric($offset)) {
        $offset = 0;
    }
    return $offset;
}




function fetch_data_from_post()
{
    $data['meta_title'] = $this->input->post('meta_title', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['meta_keywords'] = $this->input->post('meta_keywords', TRUE);
    $data['meta_description'] = $this->input->post('meta_description', TRUE);
    //$data['image'] = $this->input->post('image', TRUE);
    $data['meta_tags'] = $this->input->post('meta_tags', TRUE);
    $data['category_id'] = $this->input->post('category_id', TRUE);
    $data['body'] = $this->input->post('body', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['tags'] = $row->tags;
        $data['category_id'] = $row->category_id;
        $data['body'] = $row->body;
        $data['image'] = $row->image;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

//get item id from item url
function _get_program_id_from_program_url($url)
{
  $query = $this->get_where_custom('slug', $url);
  foreach ($query->result() as $row) {
    $blog_id = $row->id;
  }
  if (!isset($blog_id)) {
    $blog_id = 0;
  }
  return $blog_id;
}

function posts()
{
    $url = $this->uri->segment(2);
    $this->load->module('blogs');

    $blog_id = $this->blogs->_get_program_id_from_program_url($url);
    $this->blogs->view($blog_id);
}

function view($update_id)
{
    if (!is_numeric($update_id)) {
        redirect('site_security/not_allowed');
    }

    //fetch item details
    $data = $this->fetch_data_from_db($update_id);
    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['image_path']         = "assets/images/blogs/";

    $data['view_module'] = "blogs"; 
    $data['view_file'] = "view";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}

function tags($query)
{
    //SEO
    $data['meta_title']         = "Silver Emporium | Tags | Online Silver Masterpiece";
    $data['meta_description']   = "silver Emporium also shares blogs on silver related topics like silver lates updates, do it your selfs and more. We share our thoughts our experiences for other people to read";
    $data['meta_keywords']      = "pure silver products, silver 99, hallmark silver, silver blogs, silver gifts";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/blogs/";
    $data['image']              = "";

    $this->load->model('Mdl_Blogs');
    $data['blogs'] = $this->Mdl_Blogs->tags(urldecode($query),$this->uri->segment(3));
    $data['view_module'] = "blogs";
    $data['view_file'] = "tags";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}



function get($order_by)
{
    $this->load->model('Mdl_Blogs');
    $query = $this->Mdl_Blogs->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs');
    $query = $this->Mdl_Blogs->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs');
    $query = $this->Mdl_Blogs->get_where($id);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Blogs');
    $query = $this->Mdl_Blogs->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Blogs');
    $this->Mdl_Blogs->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs');
    $this->Mdl_Blogs->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs');
    $this->Mdl_Blogs->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Blogs');
    $count = $this->Mdl_Blogs->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Blogs');
    $max_id = $this->Mdl_Blogs->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Blogs');
    $query = $this->Mdl_Blogs->_custom_query($mysql_query);
    return $query;
}

}