<?php
class Blogs_category extends MX_Controller 
{

function __construct() {
parent::__construct();



    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
}

//Create category
function create()
{


    $update_id = $this->uri->segment(3);
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('blogs_category/manage');
    }

    if ($submit=="Submit") {

        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Blogs Category', 'trim|required');


        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            $data['slug'] = url_title(strtolower($data['name']));

            if (is_numeric($update_id)) {
              $data['date_created'] = time();
               //update a item
                $this->_update($update_id, $data);
                $flash_msg = "The Blogs Category Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('blogs_category/create/'.$update_id);

            } else {
                $data['date_created'] = time();
                //insert new item
                $this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item

                $flash_msg = "The Blogs Category Successfully Added   .";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('blogs_category/manage');
            }

        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add Blogs Category";
    } else {

        $data['headline'] = "Update Blogs Category";
    }

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "blogs_category";
    $data['view_file'] = "create";
    $this->load->module('templates');
    $this->templates->admin($data);
}

//Manage Blogs Category
function manage()
{
    $data['headline'] = "Blogs Category List";
    $data['flash'] = $this->session->flashdata('item');

    $data['query'] = $this->get_where_custom('status', 1);
    $data['create_blogs_category'] = base_url()."blogs-category/create";
    $data['edit'] = base_url()."blogs-category/create/";

    $data['view_module'] = "blogs_category";
    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}



function fetch_data_from_post()
{
    $data['name'] = $this->input->post('name', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['description'] = $this->input->post('description', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['name'] = $row->name;
        $data['slug'] = $row->slug;
        $data['description'] = $row->description;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function get($order_by)
{
    $this->load->model('Mdl_Blogs_category');
    $query = $this->Mdl_Blogs_category->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs_category');
    $query = $this->Mdl_Blogs_category->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs_category');
    $query = $this->Mdl_Blogs_category->get_where($id);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Blogs_category');
    $query = $this->Mdl_Blogs_category->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Blogs_category');
    $this->Mdl_Blogs_category->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs_category');
    $this->Mdl_Blogs_category->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Blogs_category');
    $this->Mdl_Blogs_category->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Blogs_category');
    $count = $this->Mdl_Blogs_category->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Blogs_category');
    $max_id = $this->Mdl_Blogs_category->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Blogs_category');
    $query = $this->Mdl_Blogs_category->_custom_query($mysql_query);
    return $query;
}

//Delete Blogs category
function delete($id)
{

      $id = $this->uri->segment(3);
      $this->_delete($id);
      $flash_msg = "The Blog Category Successfully Deleted.";
        $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
        $this->session->set_flashdata('item', $value);
        $data['flash'] = $this->session->flashdata('item');

      redirect('blogs-category/manage');

}

}