<?php
class Customisation extends MX_Controller 
{

function __construct() {
    $this->load->module('customization');
    $this->load->model('Mdl_Customisation');
    parent::__construct();
}

    public function index()
    {
        //SEO
        $data['meta_title'] = "Silver Emporium | Customization | Online Customisation";
        $data['meta_description'] = "With focus on giving our clients an out-of-the-ordinary experience , Silver Emporium promises to give a new definition to customised designs";
        $data['meta_keywords'] = "silver customised products, silver fully customised antiques, latest antiques";
        $data['cannonical']         = "";
        $data['image_path']         = "assets/images/about/";
        $data['image']              = "silver-emporium.jpg";

        $data['view_module'] = "customisation";
        $data['view_file'] = "index";
        $this->load->module('templates');
        $this->templates->public_bootstrap($data);
    }

    
    function upload_multiple()
    {
        if($_FILES["files"]["name"] != '')
        {
          $output = '';
          $config["upload_path"] = './assets/customisation/';
          $config["allowed_types"] ='jpg|jpeg|PDF|pdf|JPG|JPEG';
          $this->load->library('upload', $config);
          $this->upload->initialize($config);
          for($count = 0; $count<count($_FILES["files"]["name"]); $count++)
          {
            $_FILES["file"]["name"] = $_FILES["files"]["name"][$count];
            if($this->upload->do_upload('file'))
            {
              $data = $this->uplaod->data();
              $output = '<div class="col-md-3">
                            <img src="'.base_url().'assets/customisation/'.$data["file_name"].'" class="img img-responsive" />
                        </div>';
            }
          }
          echo $output;
        }
    }
    public function submit()
    {
        $newCustmizationDetails = $this->input->post();
        $fileName = '';
        $this->form_validation->set_rules('f_name','First Name','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
        $this->form_validation->set_rules('l_name','Last Name','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
        $this->form_validation->set_rules('contact','Contact Number','required|numeric',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'numeric' => '%s should not contain text.'
                                                ));
        $this->form_validation->set_rules('email','Email Address','required|valid_email',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'valid_email' =>'%s is not valid.'
                                                ));
        $this->form_validation->set_rules('occasion','Occasion for requirement','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));
        $this->form_validation->set_rules('city','City','required',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.'
                                                ));

        $this->form_validation->set_rules('orderprice','Targeted Price / Piece','required|numeric',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'numeric' => '%s should not contain text.'
                                                ));
        $this->form_validation->set_rules('orderquantity','Quanity','required|numeric',
                                            array(
                                                'required' => 'Please enter %s it is mandatory.',
                                                'numeric' => '%s should not contain text.'
                                                ));
        $this->form_validation->set_rules('tnc','Terms and Condition','required',
                                            array(
                                                'required' => 'You Cant proceed Without accepting %s.'
                                                ));
        if($this->form_validation->run())
        {
          if(!empty($_FILES['files']['name']))
          {
            $filesCount = count($_FILES['files']['name']);
            for($i = 0; $i < $filesCount; $i++)
            {
              $_FILES['file']['name']     = $_FILES['files']['name'][$i];
              $_FILES['file']['type']     = $_FILES['files']['type'][$i];
              $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
              $_FILES['file']['error']     = $_FILES['files']['error'][$i];
              $_FILES['file']['size']     = $_FILES['files']['size'][$i];


              
              $config['upload_path'] = './assets/customisation/';
              $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|ppt|pptx';


              $this->load->library('upload', $config);
              $this->upload->initialize($config);

               if($this->upload->do_upload('file'))
               {
                // Uploaded file data
                $fileData = $this->upload->data();
                $uploadData[$i]['file_name'] = $fileData['file_name'];
                //echo $uploadData[$i]['file_name'];
                $fileName = $fileName.$uploadData[$i]['file_name'].",";
                //echo $fileName;
              } 
            }
          }
          //echo $fileName;
              $this->load->model('Mdl_Customisation');
                $saveCustmisationDetails = $this->Mdl_Customisation->save_customisation_details($newCustmizationDetails,$fileName);
                if($saveCustmisationDetails)
                {
                    $email = $this->input->post('email', TRUE);
                    $this->send_confirmation_mail_to_user($email);
                    $this->send_confirmation_mail_to_admin($newCustmizationDetails);
                    $this->session->set_flashdata('success', "Thank you for the details we will get back to you soon !!");
                    redirect('customisation');
                }
                else
                {
                    $this->session->set_flashdata('not_success', "Data did not store !!");
                    redirect('customisation');
                }
        }
        else
        {
            $this->index();
        }
  }


public function send_confirmation_mail_to_user($email)
{ 

  $this->load->library('email');

    $subject = 'Thanks for you query in Silver Emporium';
    $message = '<table border="0" style="width: 700px; margin: 0 auto;">
                    <tr>
                      <td style="text-align: center;">
                        <img src="http://www.silverempo.com/assets/images/logo1.png" alt="" width="300px">
                      </td>
                    </tr>
                     <tr>
                      <td><br>
                        <p><strong>Dear Customer,</strong></p>
                        <p>We thank you to connect with Silver Emporium Pvt Ltd. <br>We shall get back to you soon for your query. <br><br>Regards, <br>Team Silver Emporium</p>
                      </td>
                    </tr>
                     <tr>
                      <td style="text-align: center;"><br><hr>
                        <a href="https://www.facebook.com/SilverEmporiumindia"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/facebook.png" border="0"></a>&nbsp;
                        <a href="https://www.instagram.com/silverempoguild/"><img width="32" height="32" src="http://www.silverempo.com/assets/images/icons/instagram.png" border="0"></a>&nbsp;
                      </td>
                    </tr>
                </table>';

    // Get full html:
    $body = '<!DOCTYPE html>
                <html lang="en">
                <head>
                  <meta charset="UTF-8">
                  <title> . html_escape($subject) .</title>
                  <link href="https://fonts.googleapis.com/css?family=Roboto&display=swap" rel="stylesheet">
                  <style>p{font-family: "Roboto", sans-serif; font-size: 18px; color: #767676; line-height: 24px; letter-spacing: 1px}</style>
                </head>
                <body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to($email)
      //->cc('rrcg.rahulk@gmail.com')
      ->subject($subject)
      ->message($body)
      ->send();

       //$mail_send = $this->email->print_debugger() ;
       //echo $body;     


}

public function send_confirmation_mail_to_admin($newCustmizationDetails)
{ 

  $this->load->library('email');
  $email = 'info@silverempo.com';
  

    $subject = 'You got an Customization Enquiry in Silver Emporium from: '.$newCustmizationDetails['f_name']." ".$newCustmizationDetails['l_name'];
    $message = '
    <center>
    <a href="http://www.silverempo.com/" target="_blank"><img src="http://www.silverempo.com/assets/images/logo1.png" alt="Silver  Emporium Logo" style="max-width: 250px; display: block; margin-left: auto; margin-right: auto;"></a>
    <div style="width: 700px; background-color: #fc7f7f ; color: #fff;  padding-left: 10px; padding-top: 10px; padding-bottom:  10px; padding-right: 10px; border-radius: 5px; text-align: center; margin-top: 10px;">
      <h3>New Customisation</h3>
    </div>
      <div style="width: 700px; background-color: #f7f7f7;  padding-left: 10px; padding-right: 10px; border-radius: 5px;">
      <p style="font-size: 17px; font-weight: 600; text-align: justify; margin-top: 0px; padding-top:  15px; ">Dear Admin,</p>
      <p style="font-size: 17px; text-align: justify;">Greetings from <a href="http://www.silveremporium.in/" target="_blank" style="text-decoration: none;"><span style="color: #ef4581;"><strong>Silver Emporium</strong></span></a>,</p>
      <p style="font-size: 17px; text-align: justify;">There is a  New Customisation Enquiry , details of Customisation  Enquiry is given as below,</p>
      <table id="customers" style=" border-collapse: collapse; width: 85%;">
      <tr>
          <th class="header-th" colspan="2" style="text-align: center;  padding-top: 12px; padding-bottom: 12px; text-align: center; background-color: #fc7f7f; color: #fff;">Personal Details</th>
       </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Name</th>
         <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['f_name']." ".$newCustmizationDetails['l_name'].'</td>
        </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Email</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['email'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Contact Number</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['contact'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Occasion for Requirement </th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['occasion'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">City</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['city'].'</td>
        </tr>
        <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Theme</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['ordernote'].'</td>
        </tr>
          <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Price</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['orderprice'].'</td>
        </tr>
         <tr>
          <th style="padding-top: 12px; padding-bottom: 12px; text-align: left; text-align: center; border: 1px solid #ddd; padding: 8px;">Quantity</th>
          <td style="border: 1px solid #ddd; padding: 8px;">'.$newCustmizationDetails['orderquantity'].'</td>
        </tr>
      </table>
      <p style="font-size: 17px; text-align: justify; margin-top: 10px; padding-bottom: 15px;">Thank you.</p>
    </div>
  </center>';

    // Get full html:
    $body = '<!DOCTYPE html>
<html>
<head>
  <title>Customisation Email</title>
  <link href="https://fonts.googleapis.com/css?family=Raleway&display=swap" rel="stylesheet">
  <style>
  body {
    font-family: "Raleway", sans-serif;
  }   

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}
</style>
</head>
<body>
            ' . $message . '
        </body>
      </html>';


      $result = $this->email
      ->from('info@silverempo.com', 'Silver Emporium')
      ->reply_to('info@silverempo.com')    // Optional, an account where a human being reads.
      ->to($email)
      //->cc('rrcg.rahulk@gmail.com')
      ->subject($subject)
      ->message($body)
      ->send();

       //$mail_send = $this->email->print_debugger() ;
       //echo $body;      die();


}


public function all()
{
        $data['meta_title'] = "Silver Emporium Customised Work | Silver Customised Products";
        $data['meta_description'] = "A piece of jewellery is a representation of your style statement, depicting your taste, personality and distinguishing sense of style.";
        $data['meta_keywords'] = "silver customised products, silver fully customised antiques, latest antiques";
        $data['cannonical']         = "";
        $data['image_path']         = "assets/images/about/";
        $data['image']              = "silver-emporium.jpg";

        $data['allCustomizationWork'] =$this->Mdl_Customization->get_all_customization_work();
        $data['view_module'] = "customisation";
        $data['view_file'] = "all";
        $this->load->module('templates');
        $this->templates->public_bootstrap($data);
}


function single()
{
        $slug = $this->uri->segment(3);
        $id = $this->Mdl_Customization->get_id($slug);
        $data['meta_title'] = "Silver Emporium | Silver Customised Products";
        $data['meta_description'] = "At Silver Emporium, we bring you a range of handcrafted silver designs to choose from";
        $data['meta_keywords'] = "silver customised products, silver fully customised antiques, latest antiques, silver corporate gifts, silver online gifts";
        $data['image_path']         = "assets/images/about/";
        $data['image']              = "silver-emporium.jpg";
        $data['id'] = $id;
        $data['allCustomizationWorkImages'] = $this->Mdl_Customization->get_all_customization_work_images_for_selected($id);
        $data['view_module'] = "customisation";
        $data['view_file'] = "view";
        $this->load->module('templates');
        $this->templates->public_bootstrap($data);
}

}