<?php
class Customization extends MX_Controller 
{

function __construct() {
parent::__construct();
$this->load->model('Mdl_Customization');

    



}

public function check_user_or_admin()
{
  $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }
}


function create()
{
      $this->check_user_or_admin();
      $this->load->module('accounts');
      $data['view_module'] = "customization";
      $data['view_file'] = "create";
      $this->load->module('templates');
      $this->templates->admin($data);
}

function submit()
{
  $this->check_user_or_admin();
  $this->load->model('Mdl_Customization');
  $customizationData = $this->input->post();
  $this->load->library('form_validation');
  if($this->uri->segment(3) == '')
  {
    $this->form_validation->set_rules('title', 'Title', 'required|is_unique[custmisation_work.title]');
    $this->form_validation->set_rules('body', 'Body', 'required');
    $this->form_validation->set_rules('description', 'Mini Description', 'required');
  if($this->form_validation->run())
  {
    $config = array(
        'upload_path' => './assets/images/customization/',
        'allowed_types' => 'jpg|jpeg|png|PNG|JPEG|JPG',
        'max-size' =>4000,
        'filename' => $this->input->post('file')
        );
        $this->load->library('upload', $config);
        $uploadFile =  $this->upload->do_upload('file');
        if($uploadFile)
        {
          $data = $this->upload->data();
          $fileName = $data['file_name'];
          //echo $table; die();
          $this->Mdl_Customization->add_customization_work($customizationData,$fileName);
          $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Customisation work is added successfully !!'.'</p>');
          redirect('customization/create');
        }
        else
        {
           $error = $this->upload->display_errors();
           $this->session->set_flashdata('reply', '<div class="alert alert-danger"><p> ' .$error.' </p></div>');
            $this->create();
           //print_r($error); exit();
        }
      }
      else
      {
        $this->create();
      }
  }
  else
  {
      $id = $this->uri->segment(3);
      $this->Mdl_Customization->update_customisation_work($id,$customizationData);
      $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Customisation work is Updated successfully !!'.'</p>');
      redirect('customization/create/'.$id);
  }
}

function manage()
{
    $this->check_user_or_admin();
    $this->load->module('accounts');
   // $this->load->model('Mdl_Featured_Products');
     $update_id = $this->uri->segment(3);
      $data['view_module'] = "customization";
      $data['view_file'] = "manage";
      $data['allCustomizationWork'] = $this->Mdl_Customization->get_all_customization_work();
      $this->load->module('templates');
      $this->templates->admin($data);
}

public function manage_queries()
{

  $this->check_user_or_admin();

  $data['query'] = $this->get('id');
  $data['headline'] = "Customisation Queries by Customers";


  $data['view_file'] = "manage_queries";
  $this->load->module('templates');
  $this->templates->admin($data);
}

function get($order_by)
{
    $this->load->model('Mdl_Customization');
    $query = $this->Mdl_Customization->get($order_by);
    return $query;
}

function addimage()
{
  $id = $this->uri->segment(3);
  $data['view_module'] = "customization";
  $data['view_file'] = "addimage";
  $data['allCustomizationWorkImages'] = $this->Mdl_Customization->get_all_customization_work_images_for_selected($id);
  $this->load->module('templates');
  $this->templates->admin($data);

}

function saveimage()
{
    $id = $this->uri->segment(3);
     $config = array(
        'upload_path' => './assets/images/singlecustomizeimage/',
        'allowed_types' => 'jpg|jpeg|png|PNG|JPEG|JPG',
        'max-size' =>4000,
        'filename' => $this->input->post('file')
        );
        $this->load->library('upload', $config);
        $uploadFile =  $this->upload->do_upload('file');
        if($uploadFile)
        {
          $sliderDetails = $this->input->post();
          $data = $this->upload->data();
          $fileName = $data['file_name'];
          //echo $table; die();
          $this->Mdl_Customization->add_featured_product_image($fileName,$id);
          $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Image is added successfully !!'.'</p>');
          redirect('customization/addimage/'.$id);
        }
        else
        {
           $error = $this->upload->display_errors();
           $this->session->set_flashdata('reply', '<div class="alert alert-danger"><p> ' .$error.' </p></div>');
            $this->addimage();
           //print_r($error); exit();
        }
}


public function show_queries_details($update_id)
{
    $this->check_user_or_admin();
    $url = $this->uri->segment(3);
    $this->load->module('customization');   

    $query_id = $this->customization->_get_query_id_from_query_url($url);


    $this->customization->get_details($query_id);
}

function _get_query_id_from_query_url($url)
{
  $query = $this->get_where_custom('code', $url);
  foreach ($query->result() as $row) {
    $query_id = $row->id;
  }
  if (!isset($query_id)) {
    $query_id = 0;
  }
  return $query_id;
}

function get_details($update_id)
{


    if (!is_numeric($update_id)) {
        redirect('site_security/not_allowed');
    }

    $this->check_user_or_admin();

    //fetch item details
    $data = $this->fetch_data_from_db($update_id);
    $data['update_id'] = $update_id;
    $data['headline'] = 'View Details of Selected Customization Queries';
    $data['flash'] = $this->session->flashdata('item');
       

    $data['view_module'] = "customization"; 
    $data['view_file'] = "detail_customization_queries";
    $this->load->module('templates');
    $this->templates->admin($data);
}


function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Customization');
    $query = $this->Mdl_Customization->get_where_custom($col, $value);
    return $query;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['f_name'] = $row->f_name;
        $data['l_name'] = $row->l_name;
        $data['email'] = $row->email;
        $data['mobile'] = $row->mobile;
        $data['city'] = $row->city;
        $data['occasion'] = $row->occasion;
        $data['theme'] = $row->theme;
        $data['target_price'] = $row->target_price;
        $data['quantity'] = $row->quantity;
        $data['reference_image'] = $row->reference_image;
        $data['code'] = $row->code;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Customization');
    $query = $this->Mdl_Customization->get_where($id);
    return $query;
}

function delete()
{
  $this->check_user_or_admin();
  $id = $this->uri->segment(3);
  $this->load->model('Mdl_Customization');
  $this->Mdl_Customization->delete($id);
  $this->session->set_flashdata('reply', '<p class="alert alert-success">'.'Customization Query Removed successfully !!'.'</p>');
  redirect('customization/manage-queries');
}


}