<?php
class News extends MX_Controller 
{

function __construct() {
parent::__construct();
$this->load->model('Mdl_News');
}

public function index()
{
    //SEO
    $data['meta_title']         = "Silver Emporium News | Lates News About Silver";
    $data['meta_description']   = "Silver news headlines, data, analysis, information, prices and charts from the global silver markets here at Silver Emporium so our customers are updated about silver and about our products";
    $data['meta_keywords']      = "silver trending news, silver news, silver emporium news";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";
    $this->load->module('blogs');


    //Fetch for this Page
    $use_limit = TRUE;
    $mysql_query = $this->_generate_mysql_query($use_limit);

    
    $pagination_data['template'] = 'public_bootstrap';
    $pagination_data['target_base_url'] = $this->get_target_pagination_base_url();
    $pagination_data['total_rows'] = 4;
    $pagination_data['offset_segment'] = 3;
    $pagination_data['limit'] = $this->get_limit();

    $this->load->module('custom_pagination');
    
    $data['pagination'] = $this->custom_pagination->_generate_pagination($pagination_data);

    $data['view_module'] = "news";
    $data['allNews'] = $this->Mdl_News->get_all_news();
    $data['view_file'] = "index";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}

function get_target_pagination_base_url()
{
    $first_bit = $this->uri->segment(1);
    $second_bit = $this->uri->segment(2);
    $third_bit = $this->uri->segment(3);

    $target_base_url = base_url().$first_bit."/".'index';

    return $target_base_url;
}

function _generate_mysql_query($use_limit)
{
    $mysql_query= "SELECT * FROM `blogs` WHERE STATUS=1 ORDER BY id desc";
    if ($use_limit==TRUE) {
        $limit = $this->get_limit();
        $offset = $this->get_offset();
        $mysql_query.= " limit ".$offset.", ".$limit;
    }
    return $mysql_query;
}


function get_limit()
{
    $limit = 6;
    return $limit;
}

function get_offset()
{
    $offset = $this->uri->segment(3);
    if (!is_numeric($offset)) {
        $offset = 0;
    }
    return $offset;
}




function fetch_data_from_post()
{
    $data['meta_title'] = $this->input->post('meta_title', TRUE);
    $data['slug'] = $this->input->post('slug', TRUE);
    $data['meta_keywords'] = $this->input->post('meta_keywords', TRUE);
    $data['meta_description'] = $this->input->post('meta_description', TRUE);
    //$data['image'] = $this->input->post('image', TRUE);
    $data['meta_tags'] = $this->input->post('meta_tags', TRUE);
    $data['category_id'] = $this->input->post('category_id', TRUE);
    $data['body'] = $this->input->post('body', TRUE);
    $data['date_created'] = $this->input->post('date_created', TRUE);


    return $data;
}

public function search()
{
    //print_r($this->input->get('from')); exit();
    if((($this->input->get('from') == '') || ($this->input->get('to') == '')))
    {
        $this->session->set_flashdata('reply', '<p class="alert alert-danger">'.'Please Select From date and To date for the Search!!'.'</p>');
          redirect('news');
    }
    else
    {
            $fromYear =  strtotime($this->input->get('from').' 00:00:00');
            $toYear =  strtotime($this->input->get('to').' 23:59:59');
    //echo $fromYear."from: "."<br>"."to: ".$toYear; die();
            $data['meta_title']         = "Silver Emporium News | Search Lates News About Silver";
            $data['meta_description']   = "Silver news headlines information, prices and charts from the global silver markets here at Silver Emporium so our customers are updated about silver and about our products.";
            $data['meta_keywords']      = "silver trending news, silver news, silver emporium news";
            $data['cannonical']         = "";
            $data['image_path']         = "assets/images/about/";
            $data['image']              = "silver-emporium.jpg";
            $this->load->module('news');
            $use_limit = TRUE;
            $mysql_query = $this->_generate_mysql_query($use_limit);

            
            $pagination_data['template'] = 'public_bootstrap';
            $pagination_data['target_base_url'] = $this->get_target_pagination_base_url();
            $pagination_data['total_rows'] = 5;
            $pagination_data['offset_segment'] = 3;
            $pagination_data['limit'] = $this->get_limit();

            $this->load->module('custom_pagination');
            
            $data['pagination'] = $this->custom_pagination->_generate_pagination($pagination_data);

            $data['view_module'] = "news";
            $data['allNews'] = $this->Mdl_News->get_news_by_year($fromYear,$toYear);
            $data['view_file'] = "index";
            $this->load->module('templates');
            $this->templates->public_bootstrap($data);
    }

}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['tags'] = $row->tags;
        $data['category_id'] = $row->category_id;
        $data['body'] = $row->body;
        $data['image'] = $row->image;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

//get item id from item url
function _get_program_id_from_program_url($url)
{
  $query = $this->get_where_custom('slug', $url);
  foreach ($query->result() as $row) {
    $blog_id = $row->id;
  }
  if (!isset($blog_id)) {
    $blog_id = 0;
  }
  return $blog_id;
}

function posts()
{
    $url = $this->uri->segment(2);
    $this->load->module('blogs');

    $blog_id = $this->blogs->_get_program_id_from_program_url($url);
    $this->blogs->view($blog_id);
}

function view($update_id)
{
    $data['meta_title']         = "Silver Emporium News | Lates News About Silver products";
    $data['meta_description']   = "Silver news headlines, information, prices, data, analysis, and charts from the global silver markets here at Silver Emporium so our customers are updated about silver and about our products.";
    $data['meta_keywords']      = "silver trending news, silver news, silver emporium news";
    $data['cannonical']         = "";
    $data['image_path']         = "assets/images/about/";
    $data['image']              = "silver-emporium.jpg";


    //fetch item details
    $slug = $this->uri->segment(3);
    $id = $this->Mdl_News->get_news_id($slug);
    $data['singleNews'] = $this->Mdl_News->get_single_news($id);
    $data['meta_description'] = '';
    $data['meta_keywords'] = '';
    $data['name'] = '';
    $data['view_module'] = "news"; 
    $data['view_file'] = "view";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}



}