<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Mdl_News extends CI_Model
{

function __construct() {
parent::__construct();
}

function get_table() {
    $table = "news";
    return $table;
}

function get($order_by){
    $table = $this->get_table();
    $this->db->order_by($order_by);
    $query=$this->db->get($table);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) {
    $table = $this->get_table();
    $this->db->limit($limit, $offset);
    $this->db->order_by($order_by, "desc");
    $query=$this->db->get($table);
    return $query;
}

function get_where($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $query=$this->db->get($table);
    return $query;
}

function get_where_custom($col, $value) {
    $table = $this->get_table();
    $this->db->where($col, $value);
    $query=$this->db->get($table);
    return $query;
}

function _insert($data){
    $table = $this->get_table();
    $this->db->insert($table, $data);
}

function _update($id, $data){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->update($table, $data);
}

function _delete($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->delete($table);
}

function count_where($column, $value) {
    $table = $this->get_table();
    $this->db->where($column, $value);
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function count_all() {
    $table = $this->get_table();
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function get_max() {
    $table = $this->get_table();
    $this->db->select_max('id');
    $query = $this->db->get($table);
    $row=$query->row();
    $id=$row->id;
    return $id;
}

function _custom_query($mysql_query) {
    $query = $this->db->query($mysql_query);
    return $query;
}

//search by tags

function tags($query)
{
    $q = $this->db->from('blogs')
                  ->or_like('meta_keywords',$query)
                  ->or_like('tags',$query)
                  ->get();
    return $q->result();
}

public function get_all_news()
{
     $query = $this->db->query("SELECT * FROM `news` WHERE status = 1");
        return $query->result();  
}

public function get_news_by_year($fromYear,$toYear)
{
     $query = $this->db->query("SELECT * FROM `news` WHERE date_created BETWEEN '$fromYear' AND '$toYear' ORDER BY date_created");
        return $query->result();     
}

public function get_news_id($slug)
{
     $sql = "SELECT * FROM `news` WHERE slug = '$slug'";
    $result = $this->db->query($sql);
    $row = $result->row();
     return  $row->id;   
}

public function get_single_news($id)
{
    $query = $this->db->query("SELECT * FROM `news` WHERE id = '$id' AND status = 1");
        return $query->result();   
}

}
