<?php
class Product_categories extends MX_Controller 
{

function __construct() {
parent::__construct();
}

function _get_category_id($slug)
{
  $data = $this->fetch_data_from_db_for_category($slug);
  if ($data==""){
    $category_id = "Unknown";
  } else {
    $category_id = trim($data['id']);
  }

  return $category_id;
}

function _count_sub_cats($update_id)
{
    //return the number of sub categories
    $query = $this->get_where_custom('parent_category_id', $update_id);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function create()
{

    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }

    $update_id = $this->uri->segment(3);
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('product-categories/manage');
    }

    if ($submit=="Submit") {


        $this->load->library('form_validation');
        $this->form_validation->set_rules('category_name', 'Category Title', 'trim|required');

        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            $data['slug'] = strtolower(url_title($data['category_name']));
            $data['date_created'] = time();

            if (is_numeric($update_id)) {
               //update a category
                $this->_update($update_id, $data);
                $flash_msg = "The Category Details Were Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('product-categories/create/'.$update_id);

            } else {
                //insert new category

                $this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item

                $flash_msg = "The Category Was Successfully Added   .";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('product-categories/create/'.$update_id, 'refresh');

            }

        }
    }

    if ($submit=="New") {


        $this->load->library('form_validation');
        $this->form_validation->set_rules('category_name', 'Category Title', 'trim|required');

        if ($this->form_validation->run() == TRUE){

           //get the variables
            $data = $this->fetch_data_from_post();
            $data['slug'] = strtolower(url_title($data['category_name']));
            $data['date_created'] = time();

            if (is_numeric($update_id)) {
               //update a category
                $this->_update($update_id, $data);
                $flash_msg = "The Category Details Were Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('product-categories/create/');

            } else {
                //insert new category

                $this->_insert($data);
                $update_id = $this->get_max(); // get the id of the new item

                $flash_msg = "The Category Was Successfully Added.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('product-categories/create/');
                
            }

        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add New Category";
    } else {

        $data['headline'] = "Update Category";
    }

    $data['options'] = $this->_get_dropdown_options($update_id);
    $data['num_dropdown_options'] = count($data['options']);


    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "product_categories";
    $data['view_file'] = "create";
    $this->load->module('templates');
    $this->templates->admin($data);
}

function _get_dropdown_options($update_id)
{
    if (!is_numeric($update_id)) {
        $update_id = 0;
    }

    $options[''] = "Please Select...";
    //build an array of all the parent category
    $mysql_query = "select * from product_categories where parent_category_id=0 and id!=$update_id";
    $query = $this->_custom_query($mysql_query);
    foreach($query->result() as $row){
        $options[$row->id] = $row->category_name;
    }
    return $options;
}

function fetch_data_from_post()
{
    $data['category_name'] = $this->input->post('category_name', TRUE);
    $data['parent_category_id'] = $this->input->post('parent_category_id', TRUE);


    return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
        $data['category_name'] = $row->category_name;
        $data['cat_url'] = $row->slug;
        $data['parent_category_id'] = $row->parent_category_id;

    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

function fetch_data_from_db_for_category($slug)
{

    $query = $this->get_where_slug($slug);
    foreach($query->result() as $row)
    {
        $data['id'] = $row->id;
        $data['category_name'] = $row->category_name;
        $data['cat_url'] = $row->slug;
        $data['parent_category_id'] = $row->parent_category_id;

    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}



//manage category
function manage()
{
    $this->load->library('session');
    $this->load->module('site_security');
    $this->load->module('users');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
    }

    $parent_category_id = $this->uri->segment(3);
    if (!is_numeric($parent_category_id)) {
        $parent_category_id=0;
    }

    $data['sort_this'] = TRUE;
    $data['parent_category_id'] = $parent_category_id;
    $data['flash'] = $this->session->flashdata('item');

    $data['query'] = $this->get_where_custom('parent_category_id', $parent_category_id);
    $data['headline'] = "Manage all Category";
    $data['view_module'] = "product_categories";
    $data['view_file'] = "manage";
    $this->load->module('templates');
    $this->templates->admin($data);
}

//Delete add_products
function delete($id)
{
      $this->load->library('session');
        $this->load->module('site_security');
        $this->load->module('users');
        $is_admin = $this->session->userdata('is_admin');
        if ($is_admin == 1) {
          $this->site_security->_make_sure_is_admin();
        } else {
          $this->site_security->_make_sure_logged_in();
          $user_id = $this->site_security->_get_user_id();
          $get_user_role = $this->users->_get_user_role($user_id);
          $b=$get_user_role;
          $user_roles = explode(",",$b);
          $page_role = $this->uri->segment(1);
          if(!in_array($page_role,$user_roles)) {
            $this->site_security->not_allowed_to_access_this_page();
          }
        }

        $id = $this->uri->segment(3);
        $mysql_query = "UPDATE `product_categories` SET `status`= 0 WHERE `id` = $id";
        $delete = $this->_custom_query($mysql_query);
        if ($delete = TRUE) {
            $flash_msg = "The Product Successfully Deleted.";
            $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
            $this->session->set_flashdata('item', $value);
            $data['flash'] = $this->session->flashdata('item');
            redirect('product_categories/manage');
        } else {
            $flash_msg = "Something Went Wrong.";
            $value = '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
            $this->session->set_flashdata('item', $value);
            $data['flash'] = $this->session->flashdata('item');
            redirect('product_categories/manage');
        }


}


public function get_subcategory()
{
    if (! empty($_POST["slug"])) {


    $category_id = $this->_get_category_id($_POST["slug"]);
    $mysql_query = "SELECT * FROM `product_categories` WHERE `parent_category_id` = $category_id";
    $get_subcategory = $this->_custom_query($mysql_query);
    
    
    foreach ($get_subcategory->result() as $subcategory) {
        $output = '<option value="'.$subcategory->slug.'">'.$subcategory->category_name.'</option>';
        echo $output;
    }
    
    }
    
}

function get($order_by)
{
    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->get_where($id);
    return $query;
}

function get_where_slug($slug)
{
    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->get_where_slug($slug);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Product_categories');
    $this->Mdl_Product_categories->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Product_categories');
    $this->Mdl_Product_categories->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Product_categories');
    $this->Mdl_Product_categories->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Product_categories');
    $count = $this->Mdl_Product_categories->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Product_categories');
    $max_id = $this->Mdl_Product_categories->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Product_categories');
    $query = $this->Mdl_Product_categories->_custom_query($mysql_query);
    return $query;
}

}