<?php
class Products extends MX_Controller 
{

function __construct() {
parent::__construct();

$this->load->model('Mdl_Products', 'import');
}








public function tags($query)
{
  //SEO
  $data['meta_title'] = "Tags | Silver Emporium";
  $data['meta_description'] = "";
  $data['meta_keywords'] = "";
  $data['image_path']         = "assets/images/about/";
  $data['image']              = "silver-emporium.jpg";

  $this->load->model('Mdl_Products');
  $data['products'] = $this->Mdl_Products->tags(urldecode($query),$this->uri->segment(3));
  $data['view_module'] = "products";
  $data['view_file'] = "tags";
  $this->load->module('templates');
  $this->templates->public_bootstrap($data);
}




//Detail view of product
function _get_product_id_from_product_url($url)
{
  $query = $this->get_where_custom('slug', $url);
  foreach ($query->result() as $row) {
    $product_id = $row->id;
  }
  if (!isset($product_id)) {
    $product_id = 0;
  }
  return $product_id;
}

function view()
{

    $url = $this->uri->segment(2);
    $this->load->module('products');   

    $product_id = $this->products->_get_product_id_from_product_url($url);
    

    $this->products->get_details($product_id);
}

function get_details($update_id)
{
    if (!is_numeric($update_id)) {
        redirect('site_security/not_allowed');
    }

    //fetch item details
    $data = $this->fetch_data_from_db($update_id);
    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');

    $data['image_path']         = "assets/images/products/";
       

    $data['view_module'] = "products"; 
    $data['view_file'] = "detail";
    $this->load->module('templates');
    $this->templates->public_bootstrap($data);
}


function fetch_data_from_db($update_id)
{
    $productId = '';

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    $this->load->module('site_security');
    foreach($query->result() as $row)
    {
        $data['userid'] = $this->site_security->_get_user_id(); 
        $data['id'] = $row->id;
        $productId = $row->id;
        $data['category'] = $row->category;
        $data['subcategory'] = $row->subcategory;
        $data['name'] = $row->name;
        $data['meta_title'] = $row->meta_title;
        $data['slug'] = $row->slug;
        $data['purity'] = $row->purity;
        $data['polished'] = $row->polished;
        $data['gross_weight'] = $row->gross_weight;
        $data['piece'] = $row->piece;
        $data['image'] = $row->image;
        $data['location'] = $row->location;
        $data['details'] = $row-> details;
        $data['price'] = $row->price;
        $data['code'] = $row->code;
        $data['electroforming_code'] = $row->electroforming_code;
        $data['meta_keywords'] = $row->meta_keywords;
        $data['meta_description'] = $row->meta_description;
        $data['tags'] = $row->tags;
        $data['views'] = $row->views;
        $data['likes'] = $row->likes;
        $data['status'] = $row->status;
        $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    $this->load->module('site_cookies');
    $this->load->model('Mdl_site_cookies');
    $ip =   $this->input->ip_address();
    $check = $this->Mdl_site_cookies->check_is_duplicate_ip_or_not($ip,$productId);
    if($check)
    {
        $this->Mdl_site_cookies->add_new_ip($ip,$productId);
        $this->Mdl_site_cookies->increase_view_count_of_product($productId);
    }
    return $data;
}



function get($order_by)
{
    $this->load->model('Mdl_Products');
    $query = $this->Mdl_Products->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Products');
    $query = $this->Mdl_Products->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Products');
    $query = $this->Mdl_Products->get_where($id);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Products');
    $query = $this->Mdl_Products->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Products');
    $this->Mdl_Products->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Products');
    $this->Mdl_Products->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Products');
    $this->Mdl_Products->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Products');
    $count = $this->Mdl_Products->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Products');
    $max_id = $this->Mdl_Products->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Products');
    $query = $this->Mdl_Products->_custom_query($mysql_query);
    return $query;
}
// function like()
// {
//   $this->load->module('site_security');
//   $userId = $this->site_security->_get_user_id();
//   $productId = $_POST['productid'];
//   $this->load->model('Mdl_Products');
//   if (!$this->session->userdata('user_id'))
//   {
//     $this->load->module('accounts');
//     redirect('accounts/login');
//   }
//   else
//   {
//     $checkAvailability = $this->Mdl_Products->check_availability($productId,$userId);
//     if($checkAvailability)
//     {
//       $this->Mdl_Products->delete_current_data($productId,$userId);
//       $this->Mdl_Products->decrease_count_of_likes_for_product($productId);
//     }
//     else
//     {
//       $this->Mdl_Products->add_new_data($productId,$userId);
//       $this->Mdl_Products->increase_count_of_likes_for_product($productId);
//       //echo "not there !!";
//     }
//   }
//   //$this->Mdl_Products->like_unlike_product($productId,$userId);
//   //echo $userId;
// }


function _get_product_image($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $image = "Unknown";
  } else {
    $image = trim($data['image']);
  }

  return $image;
}




}