<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Mdl_Products extends CI_Model
{

function __construct() {
parent::__construct();
}

function get_table() {
    $table = "products";
    return $table;
}


public function importData($data) {
 
    $res = $this->db->insert_batch('products',$data);
    if($res){
        return TRUE;
    }else{
        return FALSE;
    }

}

function get($order_by){
    $table = $this->get_table();
    $this->db->order_by($order_by);
    $query=$this->db->get($table);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) {
    $table = $this->get_table();
    $this->db->limit($limit, $offset);
    $this->db->order_by($order_by);
    $query=$this->db->get($table);
    return $query;
}

function get_where($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $query=$this->db->get($table);
    return $query;
}

function get_where_custom($col, $value) {
    $table = $this->get_table();
    $this->db->where($col, $value);
    $query=$this->db->get($table);
    return $query;
}

function _insert($data){
    $table = $this->get_table();
    $this->db->insert($table, $data);
}

function _update($id, $data){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->update($table, $data);
}

function _delete($id){
    $table = $this->get_table();
    $this->db->where('id', $id);
    $this->db->delete($table);
}

function count_where($column, $value) {
    $table = $this->get_table();
    $this->db->where($column, $value);
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function count_all() {
    $table = $this->get_table();
    $query=$this->db->get($table);
    $num_rows = $query->num_rows();
    return $num_rows;
}

function get_max() {
    $table = $this->get_table();
    $this->db->select_max('id');
    $query = $this->db->get($table);
    $row=$query->row();
    $id=$row->id;
    return $id;
}

function _custom_query($mysql_query) {
    $query = $this->db->query($mysql_query);
    return $query;
}



function tags($query)
{
    $q = $this->db->from('products')
                  ->or_like('meta_keywords',$query)
                  ->or_like('tags',$query)
                  ->get();
    return $q->result();
}

function check_product_liked_or_not($userid,$id)
{
    $sql = "SELECT * FROM `likes` WHERE productid = '$id' AND userid = '$userid'";
    $result = $this->db->query($sql);
    $row = $result->row();         
    if($row)
    {
        return true;
    }
    else
    {
        return false;
    }
}
        //LIKE CODE
    function _get_likes_count_of_product($productId)
    {
        $sql = "SELECT * FROM `products` WHERE id = '$productId'";
        $result = $this->db->query($sql);
        $row = $result->row();      
        return $row->likes;
    }
    public function check_availability($productId,$userId)
    {
       $sql = "SELECT * FROM `likes` WHERE productid = '$productId' AND userid = '$userId'";
        $result = $this->db->query($sql);
        $row = $result->row();   
        if($row)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function add_new_data($productId,$userId)
    {
        $date = time();
        $this->db->insert('likes',['productid'=>$productId,'userid'=>$userId,'date'=>$date,'status'=>1]);
    }


     public function delete_current_data($productId,$userId)
     {
        $this->db->delete('likes',array('productid'=>$productId,'userid'=>$userId));
     }


    public function increase_count_of_likes_for_product($productId)
    {
        $likeCount = $this->_get_likes_count_of_product($productId);   
        $this->db->set('likes', $likeCount + 1); //value that used to update column  
        $this->db->where('id', $productId); //which row want to upgrade  
        $this->db->update('products');  //table name
    }


    public function decrease_count_of_likes_for_product($productId)
    {
        $likeCount = $this->_get_likes_count_of_product($productId);   
        $this->db->set('likes', $likeCount - 1); //value that used to update column  
        $this->db->where('id', $productId); //which row want to upgrade  
        $this->db->update('products');  //table name
    }
    


}
