<?php
class Users extends MX_Controller 
{

function __construct() {
parent::__construct();

$this->load->library('form_validation');
$this->form_validation->CI =& $this;

$this->load->module('users');

}

function _get_user_name($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $user_name = "Unknown";
  } else {
    $user_name = trim($data['f_name'].' '.$data['l_name']);
  }

  return $user_name;
}

function _get_user_email($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $email = "Unknown";
  } else {
    $email = trim($data['email']);
  }

  return $email;
}

function _get_user_role($update_id)
{
  $data = $this->fetch_data_from_db($update_id);
  if ($data==""){
    $email = "Unknown";
  } else {
    $roles = trim($data['add_roles']);
  }

  return $roles;
}

function logout()
{
  unset($_SESSION['user_id']);
  $this->load->module('site_cookies');
  $this->site_cookies->_destroy_cookie();
  redirect(base_url());
}

function index()
{
  $data['email'] = $this->input->post('email', TRUE);
  $this->load->module('templates');
  $this->templates->user_login($data);
}


function submit_login()
{
  $submit = $this->input->post('submit', TRUE);

  if ($submit=="Submit") {

      $this->load->library('form_validation');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[5]|max_length[50]|callback_username_check');
      $this->form_validation->set_rules('pword', 'Password', 'trim|required|max_length[35]');

      if ($this->form_validation->run() == TRUE){
        //figure out the user id
        $col1 = 'email';
        $value1 = $this->input->post('email', TRUE);
        $col2 = 'email';
        $value2 = $this->input->post('email', TRUE);

        $query = $this->get_with_double_condition($col1, $value1, $col2, $value2);

        foreach ($query->result() as $row) {
          $user_id = $row->id;

        }

        $remember = $this->input->post('remember', TRUE);
        if ($remember=="remember-me") {
          $login_type = "longterm";
        } else {
          $login_type = "shortterm";
        }
        

        //send to the private page
        $this->_in_you_go($user_id, $login_type);

      } else {

        $this->index();
      }
  }
}

function _in_you_go($user_id, $login_type)
{

  if ($login_type=="longterm") {
    //set a cookie
    $this->load->module('site_cookies');
    $this->site_cookies->_set_cookie($user_id);
    $this->session->set_userdata('user_id', $user_id);
  } else {
    //set a session variable
    $this->session->set_userdata('user_id', $user_id);
  }

  //send teh user to the private page
  redirect('users/welcome/');
}

//callback_username_check
function username_check($str)
{

    $this->load->module('accounts');
    $this->load->module('site_security');

    $error_msg = "You didnot Enter Correct Email and/or Password";

    $col1 = 'email';
    $value1 = $str;

    $col2 = 'email';
    $value2 = $str;

    $query = $this->get_with_double_condition($col1, $value1, $col2, $value2);

    $num_rows = $query->num_rows();

    if ($num_rows<1) {
      $this->form_validation->set_message('username_check', $error_msg);
      return FALSE;
    }

    foreach ($query->result() as $row) {
      $pword_on_table = $row->pword;
    }
    $pword = $this->input->post('pword', TRUE);
    $result = $this->site_security->_verify_hash($pword, $pword_on_table);

    if ($result==TRUE) {
      
      return TRUE;
    } else {
      $this->form_validation->set_message('username_check', $error_msg);
      
      return FALSE;
    }

}

function get_with_double_condition($col1, $value1, $col2, $value2)
{
    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->get_with_double_condition($col1, $value1, $col2, $value2);
    return $query;
}

function create()
{
    $this->load->library('session');
    $this->load->module('site_security');
    $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
  }
    

    $update_id = $this->uri->segment(3);;
    $submit = $this->input->post('submit', TRUE);

    if ($submit=="Cancel"){
      redirect('users/manage');
    }

    if ($submit=="Submit") {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('f_name', 'First Name', 'trim|required', array(
          'required'      => 'Please Enter %s of the Doctor.',
        ));
        

        if ($this->form_validation->run() == TRUE){
            $data = $this->fetch_data_from_post();
            

            if (is_numeric($update_id)) {

                
                $data['add_roles'] = implode(",", $data['add_roles']);
                $date = time();
                $this->load->module('timedate');
                $data['date_created'] = $this->timedate->get_nice_date($date,'mydate');
                $this->_update($update_id, $data);
                $flash_msg = "The User Successfully Updated.";
                $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                $this->session->set_flashdata('item', $value);
                redirect('users/create/'.$update_id);
            } else {

                

                if($data['add_roles'] == '')
                {
                    $flash_msg = "Please select role for the user.";
                    $value = '<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                    $this->session->set_flashdata('item', $value);
                    $data['update_id'] = $update_id;
                    $data['flash'] = $this->session->flashdata('item');
                }
                else
                {
                    $pword = 'password';
                    $data['pword'] = $this->site_security->_hash_string($pword);
                    $data['add_roles'] = implode(",", $data['add_roles']); 
                    $date = time();
                    $this->load->module('timedate');
                    $data['date_created'] = $this->timedate->get_nice_date($date,'mydate');
                    $data['code'] = $this->site_security->generate_random_string(10);
                    //insert new item
                    $this->_insert($data);
                    $update_id = $this->get_max();

                    $flash_msg = "The User Successfully Added   .";
                    $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
                    $this->session->set_flashdata('item', $value);
                    redirect('users/manage');
                }
            }
        }
    }

    if ((is_numeric($update_id)) && ($submit!="Submit")) {

        $data = $this->fetch_data_from_db($update_id);
    } else{

        $data = $this->fetch_data_from_post();
    }

    if (!is_numeric($update_id)) {

        $data['headline'] = "Add User";
    } else {

        $data['headline'] = "Update User";
    }

    $data['update_id'] = $update_id;
    $data['flash'] = $this->session->flashdata('item');
    $data['view_module'] = "users";
    $data['view_file'] = "create";
    $this->load->module('templates');
    $this->templates->admin($data);


}


function fetch_data_from_post()
{

  $data['f_name'] = $this->input->post('f_name', TRUE);
  $data['l_name'] = $this->input->post('l_name', TRUE);
  $data['emp_id'] = $this->input->post('emp_id', TRUE);
  $data['email'] = $this->input->post('email', TRUE);
  $data['mobile'] = $this->input->post('mobile', TRUE);
  $data['designation'] = $this->input->post('designation', TRUE);
  $data['city'] = $this->input->post('city', TRUE);
  $data['state'] = $this->input->post('state', TRUE);
  $data['add_roles'] = $this->input->post('add_roles', TRUE);
  $data['date_created'] = $this->input->post('date_created', TRUE);

  return $data;
}

function fetch_data_from_db($update_id)
{

    if (!is_numeric($update_id)) {
      redirect('site_security/not_allowed');
    }
    $query = $this->get_where($update_id);
    foreach($query->result() as $row)
    {
      $data['f_name'] = $row->f_name;
      $data['l_name'] = $row->l_name;
      $data['emp_id'] = $row->emp_id;
      $data['email'] = $row->email;
      $data['mobile'] = $row->mobile;
      $data['pword'] = $row->pword;
      $data['designation'] = $row->designation;
      $data['city'] = $row->city;
      $data['state'] = $row->state;
      $data['add_roles'] = $row->add_roles;
      $data['code'] = $row->code;
      $data['status'] = $row->status;
      $data['date_created'] = $row->date_created;
    }

    if(!isset($data))
    {
        $data="";
    }
    return $data;
}

//Show all users to Admin Panel
public function manage()
{
  $this->load->module('site_security');
  $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
  }

  $data['flash'] = $this->session->flashdata('Accounts');

  $data['query'] = $this->get('id');
  $data['headline'] = 'View all Admins of Silver Emporium';
  $data['view_file'] = "manage";
  $this->load->module('templates');
  $this->templates->admin($data);
}

public function change_password()
{
  $this->load->module('site_security');
  $submit = $this->input->post('submit', TRUE);
  $this->site_security->_make_sure_logged_in();
  $update_id = $this->site_security->_get_user_id();
 
  if ($submit == 'Submit') {
    $this->load->library('form_validation');
    $this->form_validation->set_rules('pword', 'Password', 'trim|required|min_length[7]|max_length[35]');
    $this->form_validation->set_rules('conf_pword', 'Confirm Password', 'trim|required|matches[pword]');

    if ($this->form_validation->run() == TRUE){
      $pword = $this->input->post('pword', TRUE);
      $this->load->module('site_security');
      $data['pword'] = $this->site_security->_hash_string($pword);
      $this->_update($update_id, $data);


      
      $flash_msg = "Your Password has been Successfully Updated.";
      $value = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">×</button>'.$flash_msg.'</div>';
      $this->session->set_flashdata('item', $value);
      redirect('users/change-password');
    }
  }

  $data['flash'] = $this->session->flashdata('item');
  $this->load->module('users');
  $data['view_file'] = "change_password";
  $this->load->module('templates');
  $this->templates->admin($data);
}

public function welcome()
{
    $this->load->module('site_security');
    $this->site_security->_make_sure_logged_in();
    $user_id = $this->session->userdata('user_id');

    $data['flash'] = $this->session->flashdata('item');
    $data['view_file'] = "welcome";
    $this->load->module('templates');
    $this->templates->admin($data);
}

function get($order_by)
{
    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->get($order_by);
    return $query;
}

function get_with_limit($limit, $offset, $order_by) 
{
    if ((!is_numeric($limit)) || (!is_numeric($offset))) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->get_with_limit($limit, $offset, $order_by);
    return $query;
}

function get_where($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->get_where($id);
    return $query;
}

function get_where_custom($col, $value) 
{
    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->get_where_custom($col, $value);
    return $query;
}

function _insert($data)
{
    $this->load->model('Mdl_Users');
    $this->Mdl_Users->_insert($data);
}

function _update($id, $data)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Users');
    $this->Mdl_Users->_update($id, $data);
}

function _delete($id)
{
    if (!is_numeric($id)) {
        die('Non-numeric variable!');
    }

    $this->load->model('Mdl_Users');
    $this->Mdl_Users->_delete($id);
}

function count_where($column, $value) 
{
    $this->load->model('Mdl_Users');
    $count = $this->Mdl_Users->count_where($column, $value);
    return $count;
}

function get_max() 
{
    $this->load->model('Mdl_Users');
    $max_id = $this->Mdl_Users->get_max();
    return $max_id;
}

function _custom_query($mysql_query) 
{
    $this->load->model('Mdl_Users');
    $query = $this->Mdl_Users->_custom_query($mysql_query);
    return $query;
}

function delete($id)
{
  $this->load->library('session');
  $this->load->module('site_security');
  $is_admin = $this->session->userdata('is_admin');
    if ($is_admin == 1) {
      $this->site_security->_make_sure_is_admin();
    } else {
      $this->site_security->_make_sure_logged_in();
      $user_id = $this->site_security->_get_user_id();
      $get_user_role = $this->users->_get_user_role($user_id);
      $b=$get_user_role;
      $user_roles = explode(",",$b);
      $page_role = $this->uri->segment(1);
      if(!in_array($page_role,$user_roles)) {
        $this->site_security->not_allowed_to_access_this_page();
      }
  }

  $id = $this->input->post('id');
  $this->_delete($id);

  redirect('users/manage');

}

}